// $Log: dstream.h,v $
// Revision 1.1  1997/09/10 13:37:49  am
// Initial revision
//

#if !defined( __DSTREAM_H )
#define __DSTREAM_H

#include <iostream.h>

// ---------------------------------------------------------------------------
// icstream

// stream di input di caratteri
class icstream {
  public:
    virtual ~icstream();
  
    virtual char get() = 0;
    virtual bool eof() = 0;
  };

// ---------------------------------------------------------------------------
// ocstream

// stream di output di caratteri
class ocstream {
  public:
    virtual ~ocstream();
  
    virtual void put(char c) = 0;
    virtual void flush() = 0;
  };

// ----------------------------------------------------------------------------
// icfstream

// stream di input di caratteri mappato su uno stream
class icfstream : public icstream {
    istream& is;
    int last;
  public:
    icfstream(istream& Ais);
  
    virtual char get();
    virtual bool eof();
  };

// ---------------------------------------------------------------------------
// ocfstream

// stream di output di caratteri mappato su uno stream
class ocfstream : public ocstream {
    ostream& os;
  public:
    ocfstream(ostream& Aos);
  
    virtual void put(char c);
    virtual void flush();
  };

// ----------------------------------------------------------------------------
// icscramblestream

// note:
//   lo stream viene elaborato in xor con una sequenza casuale per assicurarsi
//   che la distribuzione dei bit 0,1 sia uniforme, (NON viene usata per fini
//   crittografici)

class icscramblestream : public icstream {
    icstream& is;
    // seme per il generatore di caratteri casuali
    unsigned long seed;
  public:
    icscramblestream(icstream& Ais);
  
    virtual char get();
    virtual bool eof();
  };

// ----------------------------------------------------------------------------
// ocscramblestream

// note:
//   lo stream viene elaborato in xor con una sequenza casuale per assicurarsi
//   che la distribuzione dei bit 0,1 sia uniforme, (NON viene usata per fini
//   crittografici)

class ocscramblestream : public ocstream {
    ocstream& os;
    // seme per il generatore di caratteri casuali
    unsigned long seed;
  public:
    ocscramblestream(ocstream& Aos);
  
    virtual void put(char c);
    virtual void flush();
  };

// ----------------------------------------------------------------------------
// ocwrapstream

// Lo stream viene giustificato convertendo alcuni spazi in newline
// note:
//   le parole non vengono mai spezzate, puo' quindi accadere
//   di avere righe piu' lunghe del limite 

// massimo numero di caratteri per linea, (newline finale escluso)
#define WRAP 72

class ocwrapstream : public ocstream {
    ocstream& os;
    // linea in costruzione, 0 finale compreso
    char* line;
    // spazio allocato per line
    unsigned max;
    // numero ci caratteri in line, (escluso lo 0)
    unsigned len;
  public:
    ocwrapstream(ocstream& Aos);
    virtual ~ocwrapstream();
  
    virtual void put(char c);
    virtual void flush();
  };

// ----------------------------------------------------------------------------
// icunwrapstream

// lo stream viene ricostruito su una sola riga :
// 1) tutti gli spazi iniziali vengono elimiati
// 2) ogni sequenza di spazi consecutivi viene convertita nel carattere ' '

class icunwrapstream : public icstream {
    icstream& is;
    // ultimo carattere era uno spazio
    bool pred_space;
    // carattere in output
    char c;
    // c e' valido
    bool full;
  public:
    icunwrapstream(icstream& Ais);
  
    virtual char get();
    virtual bool eof();
  };

// ---------------------------------------------------------------------------
// ibstream

// stream di input orientato ai singoli bit
// note:
//   se si effettuano letture oltre la fine dello stream (eof() == true)
//   vengono restituiti bit virtuali nulli

class ibstream {
    icstream& is;
    // bit bufferizzati
    unsigned mbit; 
    unsigned nbit; 
    // numero bit virtuali estratti, sono bit aggiunti automaticamente 
    // in coda allo stream se si effettuano letture oltre la fine dello stream
    unsigned virtual_bit; 
  
    void look(unsigned Anbit);
    void look_novirtual(unsigned Anbit);
  public:
    ibstream(icstream& Ais);
  
    bool get();
    void get(unsigned Anbit, unsigned& Ambit);
    bool peek(unsigned Anbit, unsigned Ambit);
    void skip(unsigned Anbit);
  
    bool eof();

    bool no_wrap();
  };

inline bool ibstream::eof() { 
  return nbit==0 && is.eof(); 
}

// ---------------------------------------------------------------------------
// obstream

// stream di output orientato ai singoli bit

class obstream {
    // bit 
    unsigned mbit; 
    unsigned nbit; 
    ocstream& os;
  
  public:
    obstream(ocstream& Aos);

    void put(bool bit);
    void put(unsigned Anbit, unsigned Ambit);
  
    void flush();
  };


#endif
