// $Log: exmimic.cc,v $
// Revision 1.3  1997/08/26 15:59:02  am
// Inclusione condizionale di config.h
//
// Revision 1.2  1997/07/04 20:47:09  am
// formato nomi file 8.3
//
// Revision 1.1  1997/07/04 17:31:31  am
// Initial revision
//
// Revision 1.1  1997/06/12 19:02:47  am
// Initial revision
//

#if !defined( __MSDOS__ )
#include <config.h>
#endif

#include <stdlib.h>
#include <fstream.h>

#include <debug.h>

#include <letter.h>
#include <word.h>

// Definire una delle due per scegliere la modalit
//#define WORD
#define LETTER

// file da cui importare il dizionario
#define DIZ_IMPORT "radio-se.txt"
// file dove salvare il dizionario
#define DIZ_OUT "ttei.diz"
// input di stego
#define STEGO_IN "test.bin"
// output di stego
#define STEGO_OUT "ttei.ste"
// input di unstego
#define UNSTEGO_IN STEGO_OUT
// output di unstego
#define UNSTEGO_OUT "ttei.uns"

int main() {

#ifdef LETTER 
  cout << "stego-letter" << endl;
  dictionary_letter diz;
#endif
#ifdef WORD
  cout << "stego-word" << endl;
  dictionary_word diz;
#endif  
  
  cout << "diz import" << endl;
  ifstream ifzi( DIZ_IMPORT, ios::in );
#ifdef LETTER 
  diz.import( ifzi, 5 );
#endif
#ifdef WORD
  diz.import( ifzi, 3 );
#endif  
  ifzi.close();
  
  cout << "alpha: " << diz.alpha_count() << endl;
  cout << "context: " << diz.context_count() << endl;
  cout << "element: " << diz.element_count() << endl;
  cout << "expansion factor: " << diz.expansion_factor() << endl;

  cout << "diz save" << endl;
  ofstream ofzs( DIZ_OUT, ios::out | ios::trunc );
  ofzs << diz;
  ofzs.close();

  cout << "stego" << endl;
  ifstream ifs( STEGO_IN, ios::in );
  ofstream ofs( STEGO_OUT, ios::out | ios::trunc );
  diz.stego( ofs, ifs );
  ifs.close();
  ofs.close();
  
  cout << "unstego" << endl;
  ifstream ifu( UNSTEGO_IN, ios::in );
  ofstream ofu( UNSTEGO_OUT, ios::out | ios::trunc );
  diz.unstego( ofu, ifu );
  ifu.close();
  ofu.close();
  
  return EXIT_SUCCESS;
}
