// $Log: exmodel.cc,v $
// Revision 1.3  1997/09/03 07:10:24  am
// close non gestisce piu' errori
//
// Revision 1.2  1997/08/26 15:59:02  am
// Inclusione condizionale di config.h
//
// Revision 1.1  1997/07/04 17:32:02  am
// Initial revision
//
// Revision 1.1  1997/06/12 19:02:47  am
// Initial revision
//

#if !defined( __MSDOS__ )
#include <config.h>
#endif

#include <time.h>
#include <stdlib.h>

#include <fstream.h>

#include <debug.h>

#include <model.h>
#include <mimic.h>
#include <letter.h>
#include <word.h>

// ---------------------------------------------------------------------------

#define MAX 5000

dictionary_word diz;

void run(unsigned rate, unsigned max) {
  PRECONDITION( max <= MAX );

  cout << "rate:" << rate << ", input:" << max << flush;
  
  coder_dictionary c(diz);
  decoder_standard d(rate);
  model m(c,d,32);
  
  // vettore casuale
  bool test[MAX];
  for(unsigned i=0;i<max;++i)
    test[i] = (rand() % 2) != 0;
    
  // inserisce nel codificatore
  for(unsigned i=0;i<max;++i) { 
    m.put( test[i] );
  }
  m.close();
  
  cout << ", iter rate:" << m.iteration_rate_get() << flush;
  cout << ", iter:" << m.iteration_get() << flush;

  // controlla
  decoder_standard dt(rate);
  unsigned s = 0;
  unsigned j = 0;
  while (!m.empty()) {
    dt.put( m.get() );
    ++s;
    while (!dt.empty()) {
      if (dt.get() != test[j++]) {
	ERROR( "bad output" );
      }
    }
  }
  if (j!=max) {
    ERROR( "bad output");
  }
  cout << ", output:" << s;
  
  cout << endl;
}

int main() {

  cout << "wait, import..." << endl;
  ifstream ifzi( "radio-se.txt", ios::in );
  diz.import( ifzi, 3 );
  ifzi.close();
  
  srand(time(0));
  while (true)
    run( 8 + rand() % 32, 100 + rand() % (MAX-100)  );
  
  return EXIT_SUCCESS;
}
