// $Log: heap.cc,v $
// Revision 1.3  1997/08/26 15:59:02  am
// Inclusione condizionale di config.h
//
// Revision 1.2  1997/06/12 20:36:30  am
// aggiunte minori
//
// Revision 1.1  1997/06/12 19:02:47  am
// Initial revision
//

#if !defined( __MSDOS__ )
#include <config.h>
#endif

#include <sys/types.h>
#include <stdlib.h>

#include <heap.h>

allocator_fixed_block::allocator_fixed_block() : next(0), data(0) {
#if !defined( NDEBUG )
  debug_size = 0;
  debug_count = 0;
#endif
}

allocator_fixed_block::~allocator_fixed_block() {
  if (data) {
    delete [] data;
    if (next)
      delete next;
  }
}

void* allocator_fixed_block::grow(unsigned size, unsigned count) {
  if (data) {
    if (!next)
      next = new allocator_fixed_block;
    return next->grow(size,count);
  } else {
    data = new char[ count * size ];

    char* ptr0 = data;
    char* ptr1 = data + size;
    for(unsigned i=count-1;i>0;--i) {
      *(void**)ptr0 = ptr1;
      ptr0 = ptr1;
      ptr1 += size;
    }
    *(void**)ptr0 = 0;

#if !defined( NDEBUG )    
    debug_size = size;
    debug_count = count;
#endif
    return data;
  }
}

#if !defined( NDEBUG )
bool allocator_fixed_block::check(void* p) {
  // cast
  ptrdiff_t t = ((char*)p) - data;
  ptrdiff_t div = t / debug_size;
  ptrdiff_t mod = t % debug_size;
  // cast
  return (mod==0 && div>=0 && div<(ptrdiff_t)debug_count) || (next && next->check(p));
}
#endif

allocator_fixed::allocator_fixed(unsigned Asize, unsigned Amem) {
  mem = Amem;
  size = Asize;
  if (size < sizeof(void*))
    size = sizeof(void*);
  base = 0;
#if !defined( NDEBUG )  
  debug_counter = 0;
#endif
}

allocator_fixed::~allocator_fixed() {
  PRECONDITION( debug_counter == 0 );
}

#if !defined( NDEBUG )    
void* allocator_fixed::allocate(unsigned Asize) {
  PRECONDITION( size <= Asize );
  ++debug_counter;
#else  
void* allocator_fixed::allocate(unsigned) {
#endif
  if (!base)
    base = data.grow( size, mem / size );
  void* r = base;
  base = *(void**)base;
//  CHECK( data.check( r ) );
  return r;
}

void allocator_fixed::deallocate(void* p) {
  PRECONDITION( p );
  PRECONDITION( debug_counter > 0 );
#if !defined( NDEBUG )  
  --debug_counter;
//  CHECK( data.check( p ) );
#endif
  *(void**)p = base;
  base = p;
}

