// $Log: heap.h,v $
// Revision 1.3  1997/09/05 19:53:06  am
// Eliminato S|LogS| [D[D[D[D[C[4~[C[C
//
// Revision 1.2  1997/06/12 20:39:14  am
// Aggiunto Log
//

#if !defined( __HEAP_H )
#define __HEAP_H

#include <debug.h>

const allocator_page = 4096;

// --------------------------------------------------------------------------
// allocator_fixed

class allocator_fixed_block {
    allocator_fixed_block* next;
    char* data;
#if !defined( NDEBUG )  
    unsigned debug_size;
    unsigned debug_count;
#endif

    allocator_fixed_block(const allocator_fixed_block&);
    allocator_fixed_block& operator=(const allocator_fixed_block&);
  public:
    allocator_fixed_block();
    ~allocator_fixed_block();

    void* grow(unsigned size, unsigned count);

#if !defined( NDEBUG )
    bool check(void*);
#endif
  };

class allocator_fixed {
  public:
    allocator_fixed(unsigned Asize, unsigned Amem);
    ~allocator_fixed();

    void* allocate(unsigned Asize);
    void deallocate(void* p);

  private:
    allocator_fixed_block data;
    void* base;
    unsigned size;
    unsigned mem;
#if !defined( NDEBUG )  
    unsigned long debug_counter;
#endif
  };

#endif
    
