// $Log: iobit.cc,v $
// Revision 1.6  1997/09/06 07:45:27  am
// Modifiche minori
//
// Revision 1.5  1997/09/05 13:35:38  am
// Modificata funzione di hash
//
// Revision 1.4  1997/09/02 21:32:53  am
// Corretto bug in word_wrap
// Modificato comportamento di ioconnect
// Aggiunti iochar2bit, siochar_nop, siobit_nop
//
// Revision 1.3  1997/09/01 20:23:55  am
// Corretti commenti
//
// Revision 1.2  1997/08/26 15:59:02  am
// Inclusione condizionale di config.h
//
// Revision 1.1  1997/06/12 18:58:56  am
// Initial revision
//

#pragma implementation

#if !defined( __MSDOS__ )
#include <config.h>
#endif

#include <ctype.h>    

#include <iobit.h>

template <class T> inline T& noconst(const T& A) { return (T&)A; }

// ---------------------------------------------------------------------------
// iobit
    
iobit::~iobit() {
}

// ---------------------------------------------------------------------------
// state

state::~state() {
}

// ---------------------------------------------------------------------------
// siobit_nop

siobit_nop_state::~siobit_nop_state() {
}

siobit_nop::siobit_nop() {
  full = false;
}

siobit_nop::~siobit_nop() {
}
  
void siobit_nop::put(bool Ab) {
  PRECONDITION( !full );
  b = Ab;
  full = true;
}

void siobit_nop::close() {
}
  
bool siobit_nop::get() {
  PRECONDITION( full );
  full = false;
  return b;
}

bool siobit_nop::empty() const { 
  return !full;
}
  
state* siobit_nop::tell() const {
  siobit_nop_state* s = new siobit_nop_state;
  s->b = b;
  s->full = full;
  return s;
}

void siobit_nop::seek(const state* s) {
  b = ((siobit_nop_state*)s)->b;
  full = ((siobit_nop_state*)s)->full;
}


// ---------------------------------------------------------------------------
// iochar

iochar::~iochar() {
}

// ---------------------------------------------------------------------------
// siochar_nop

siochar_nop_state::~siochar_nop_state() {
}

siochar_nop::siochar_nop() {
  full = false;
}

siochar_nop::~siochar_nop() {
}
  
void siochar_nop::put(char ch) {
  PRECONDITION( !full );
  c = ch;
  full = true;
}

void siochar_nop::close() {
}
  
char siochar_nop::get() {
  PRECONDITION( full );
  full = false;
  return c;
}

bool siochar_nop::empty() const { 
  return !full;
}
  
state* siochar_nop::tell() const {
  siochar_nop_state* s = new siochar_nop_state;
  s->c = c;
  s->full = full;
  return s;
}

void siochar_nop::seek(const state* s) {
  c = ((siochar_nop_state*)s)->c;
  full = ((siochar_nop_state*)s)->full;
}
 
// --------------------------------------------------------------------------
// word wrap

#ifdef HEAP
allocator_fixed word_wrap_state::allocator( sizeof(word_wrap_state), allocator_page );
#endif

word_wrap_state::~word_wrap_state() {
}

word_wrap::word_wrap(unsigned Amax) {
  max = Amax;
  len = 0;
  // inizio da 1 perche' spesso si richiede di inserire un carattere in testa
  input_begin = 1;
  input_end = 1;
  output_begin = 0;
  output_end = 0;
  first = true;
}
 
word_wrap::~word_wrap() {
}

// manda in output il carattere c ed in seguito l'input
inline void word_wrap::input_to_output(char c) {   
  PRECONDITION( input_begin > 0 );
  output_begin = input_begin - 1;
  output_end = input_end;
  map[output_begin] = c;
  // inizio da 1 perche' spesso si richiede di inserire un carattere in testa
  input_begin = 1;
  input_end = 1;
}

// manda in output il carattere c 
inline void word_wrap::to_output(char c) {   
  PRECONDITION( output_begin == output_end );
  PRECONDITION( input_begin == input_end );
  output_begin = 0;
  output_end = 1;
  map[0] = c;
}
 
inline void word_wrap::to_input(char c) {   
  PRECONDITION( input_end <= WORD_MAX );
  PRECONDITION( output_begin == output_end );
  if (input_end == WORD_MAX) {
    ERROR( "word overflow" );
  }
  map[input_end++] = c;
}
    
void word_wrap::put(char c) {
  PRECONDITION( empty() );
  if (isspace(c)) {
    if (first) {
      PRECONDITION( input_begin == input_end );
      if (len + 2 <= max) {
	// ci puo' stare un altra parola
	first = false;
      } else {
	// deve andare a capo
	first = true;
	len = 0;
	to_output('\n');
      }
    } else {
      // lunghezza parola
      unsigned input_len = input_end - input_begin;
      // solo se c'e' input, altrimenti significa spazi consecutivi
      if (input_len) {
        if (len + 1 + input_len <= max) {
	  // se ci sta' sulla stessa riga
  	  len += 1 + input_len;
          input_to_output(' ');
        } else {
	  // se non ci sta' sulla stessa riga 
  	  first = true;
	  len = input_len;
	  input_to_output('\n');
        }
      }
    } 
  } else {
    if (first) {
      ++len;
      to_output(c);
    } else 
      to_input(c);
  }
}
  
void word_wrap::close() {
  PRECONDITION( empty() );
  if (!first) {
    unsigned input_len = input_end - input_begin;
    if (len + 1 + input_len <= max) {
      // se ci sta' sulla stessa riga
      len += 1 + input_len;
      input_to_output(' ');
    } else {
      // se non ci sta' sulla stessa riga 
      first = true;
      len = input_len;
      input_to_output('\n');
    }
  } 
}
  
char word_wrap::get() {
  PRECONDITION( !empty() );
  char c = map[output_begin++];
  return c;
}
  
bool word_wrap::empty() const {
  return output_begin == output_end;
}
  
state* word_wrap::tell() const {
  word_wrap_state* s = new word_wrap_state;
  s->len = len;
  s->map = map;
  s->input_begin = input_begin;
  s->input_end = input_end;
  s->output_begin = output_begin;
  s->output_end = output_end;
  s->first = first;  
  return s;
}
  
void word_wrap::seek(const state* s) {  
  len = ((const word_wrap_state*)s)->len;
  map = ((const word_wrap_state*)s)->map;
  input_begin = ((const word_wrap_state*)s)->input_begin;
  input_end = ((const word_wrap_state*)s)->input_end;
  output_begin = ((const word_wrap_state*)s)->output_begin;
  output_end = ((const word_wrap_state*)s)->output_end;
  first = ((const word_wrap_state*)s)->first;  
}



// ---------------------------------------------------------------------------
// char2bit

#ifdef HEAP
allocator_fixed char2bit_state::allocator( sizeof(char2bit_state), allocator_page );
#endif

char2bit_state::~char2bit_state() {
}

char2bit::char2bit() {
  nbit = 0;
}

char2bit::~char2bit() {
}
    
void char2bit::put(char ch) {
  PRECONDITION( empty() );
  mbit = (unsigned char)ch;
  nbit = CHAR_BIT;
}

void char2bit::close() {  
  PRECONDITION( empty() );
}

bool char2bit::get() {
  PRECONDITION( !empty() );
  bool bit = (mbit & 1) != 0;
  mbit >>= 1;
  --nbit;
  return bit;
}

bool char2bit::empty() const { 
  return nbit == 0;
}

state* char2bit::tell() const {
  char2bit_state* s = new char2bit_state;
  s->nbit = nbit;
  s->mbit = mbit;
  return s;
}

void char2bit::seek(const state* s) {
  nbit = ((const char2bit_state*)s)->nbit;
  mbit = ((const char2bit_state*)s)->mbit;
}

// ---------------------------------------------------------------------------
// bit2char

#ifdef HEAP
allocator_fixed bit2char_state::allocator( sizeof(bit2char_state), allocator_page );
#endif

bit2char_state::~bit2char_state() {
}

bit2char::bit2char() {
  nbit = 0;
  mbit = 0;
}

bit2char::~bit2char() {
}
    
void bit2char::put(bool bit) {
  PRECONDITION( empty() );
  if (bit)
    mbit |= 1 << nbit;
  ++nbit;
}

void bit2char::close() {  
  PRECONDITION( empty() );
}

char bit2char::get() {
  PRECONDITION( !empty() );
  char c = (char)(unsigned char)mbit;
  nbit = 0;
  mbit = 0;
  return c;
}

bool bit2char::empty() const { 
  PRECONDITION( nbit <= CHAR_BIT );
  return nbit != CHAR_BIT;
}

state* bit2char::tell() const {
  bit2char_state* s = new bit2char_state;
  s->nbit = nbit;
  s->mbit = mbit;
  return s;
}

void bit2char::seek(const state* s) {
  nbit = ((const bit2char_state*)s)->nbit;
  mbit = ((const bit2char_state*)s)->mbit;
}

// ---------------------------------------------------------------------------

#ifdef HEAP
allocator_fixed iochar2bit_state::allocator( sizeof(iochar2bit_state), allocator_page );
#endif

iochar2bit_state::~iochar2bit_state() {
  delete b2c;
  delete c;
  delete c2b;
}

iochar2bit::iochar2bit(siochar* Ac) {
  b2c = new bit2char; 
  c = Ac;
  c2b = new char2bit;

  close_level = 0;
}

iochar2bit::~iochar2bit() {
  delete b2c;
  delete c;
  delete c2b;
}

void iochar2bit::put(bool bit) {
  b2c->put(bit);
}

void iochar2bit::close() {
  PRECONDITION( close_level == 0 );
  b2c->close();
  close_level = 1;
}
  
bool iochar2bit::get() {
  return c2b->get();
}

bool iochar2bit::empty() const {
  while (c2b->empty() && !c->empty()) {
    c2b->put( c->get() );
  }
  while (c2b->empty() && !b2c->empty()) {
    c->put( b2c->get() );
    while (c2b->empty() && !c->empty()) {
      c2b->put( c->get() );
    }
  }
  if (c2b->empty() && close_level==1) {
    c->close();
    ((iochar2bit*)this)->close_level = 2;
    while (c2b->empty() && !c->empty()) {
      c2b->put( c->get() );
    }
  }
  if (c2b->empty() && close_level==2) {
    c2b->close();
    ((iochar2bit*)this)->close_level = 3;
  }
  return c2b->empty();
}

state* iochar2bit::tell() const {
  iochar2bit_state* s = new iochar2bit_state;
  s->c2b = c2b->tell();
  s->b2c = b2c->tell();
  s->c = c->tell();
  s->close_level = close_level;
  return s;
}

void iochar2bit::seek(const state* s) {
  c2b->seek( ((iochar2bit_state*)s)->c2b );
  b2c->seek( ((iochar2bit_state*)s)->b2c );
  c->seek( ((iochar2bit_state*)s)->c );
  close_level = ((iochar2bit_state*)s)->close_level;
}

// ---------------------------------------------------------------------------
// iobit_buffer_static

iobit_buffer_static::iobit_buffer_static() {
  output_pos = 0;
}

iobit_buffer_static::~iobit_buffer_static() {
}

void iobit_buffer_static::put(bool bit) {
  data.push_back( bit );
}

void iobit_buffer_static::close() {
}
  
bool iobit_buffer_static::get() {
  PRECONDITION( !empty() );
  bool bit = data[output_pos];
  ++output_pos;
  // reinizializza
  if (output_pos == data.size()) {
    data.erase( data.begin(), data.end() );
    output_pos = 0;
  }
  return bit;
}

bool iobit_buffer_static::empty() const { 
  PRECONDITION( output_pos <= data.size() );
  return output_pos == data.size();
}
  
state* iobit_buffer_static::tell() const {
  PRECONDITION( empty() );
  return 0;
}

void iobit_buffer_static::seek(const state*) {
  data.erase( data.begin(), data.end() );
  output_pos = 0;
}

unsigned iobit_buffer_static::size() const {
  return data.size() - output_pos;
}

// ---------------------------------------------------------------------------
// iobit_buffer

#ifdef HEAP
allocator_fixed iobit_buffer_state::allocator( sizeof(iobit_buffer_state), allocator_page );
#endif

iobit_buffer_state::~iobit_buffer_state() {
}

iobit_buffer::iobit_buffer() {
  output_pos = 0;
}

iobit_buffer::~iobit_buffer() {
}

void iobit_buffer::put(bool bit) {
  data.push_back( bit );
}

void iobit_buffer::close() {
}

bool iobit_buffer::get() {
  PRECONDITION( !empty() );
  bool bit = data[output_pos];
  ++output_pos;
  return bit;
}

bool iobit_buffer::empty() const {  
  PRECONDITION( output_pos <= data.size() );
  return output_pos == data.size();
}

state* iobit_buffer::tell() const {
  iobit_buffer_state* s = new iobit_buffer_state;
  s->output_pos = output_pos;
  s->input_pos = data.size();
  return s;
}

void iobit_buffer::seek(const state* s) {
  PRECONDITION( ((const iobit_buffer_state*)s)->input_pos <= data.size() );
  data.erase( data.begin() + ((const iobit_buffer_state*)s)->input_pos, data.end() );
  PRECONDITION( ((const iobit_buffer_state*)s)->output_pos <= data.size() );
  output_pos = ((const iobit_buffer_state*)s)->output_pos;
  CHECK( ((const iobit_buffer_state*)s)->input_pos == data.size() );
}

// return:
//   elementi nel iobit_buffer
unsigned iobit_buffer::size() const {
  return data.size() - output_pos;
}

// ---------------------------------------------------------------------------
// ioconnect

#ifdef HEAP
allocator_fixed ioconnect_state::allocator( sizeof(ioconnect_state), allocator_page );
#endif

ioconnect_state::~ioconnect_state() {
  delete a;
  delete b;
}

ioconnect::ioconnect(siobit* Aa, siobit* Ab) {
  a = Aa;
  b = Ab;
  close_level = 0;
}

ioconnect::~ioconnect() {
  delete a;
  delete b;
}

void ioconnect::put(bool bit) {
  a->put(bit);
}

void ioconnect::close() {
  PRECONDITION( close_level == 0 );
  a->close();
  close_level = 1;
}
  
bool ioconnect::get() {
  return b->get();
}

bool ioconnect::empty() const { 
  while (b->empty() && !a->empty()) {
    b->put( a->get() );
  }
  if (b->empty() && close_level == 1) {
    b->close();
    ((ioconnect*)this)->close_level = 2;
  }
  return b->empty();
}

state* ioconnect::tell() const {
  ioconnect_state* s = new ioconnect_state;
  s->a = a->tell();
  s->b = b->tell();
  s->close_level = close_level;
  return s;
}

void ioconnect::seek(const state* s) { 
  a->seek( ((ioconnect_state*)s)->a );
  b->seek( ((ioconnect_state*)s)->b );
  close_level = ((ioconnect_state*)s)->close_level;
}

// ---------------------------------------------------------------------------
// end_protocol

void iobit_code_end_protocol::put(bool bit) {
  PRECONDITION( empty() );
  nbit = true;
  mbit = bit;
}

void iobit_code_end_protocol::close() {
  put( true );
}
  
bool iobit_code_end_protocol::get() {
  PRECONDITION( !empty() );
  nbit = false;
  return mbit;
}
    
bool iobit_code_end_protocol::empty() const {  
  return nbit == false;
}

iobit_decode_end_protocol::iobit_decode_end_protocol() {
  ione = false;
  izero = 0;
  oone = false;
  ozero = 0;
}

void iobit_decode_end_protocol::put(bool bit) {
  PRECONDITION( empty() );
  if (bit) {
    oone = ione;
    ozero = izero;
    ione = true;
    izero = 0;
  } else {
    ++izero;
  }
}

void iobit_decode_end_protocol::close() {
  PRECONDITION( ione );
}
  
bool iobit_decode_end_protocol::get() {
  PRECONDITION( !empty() );
  if (oone) {
    oone = false;
    return true;
  }
  --ozero;
  return false;
}
    
bool iobit_decode_end_protocol::empty() const {  
  return !oone && ozero == 0;
}

// ---------------------------------------------------------------------------
// decoder_standard

#ifdef HEAP
allocator_fixed decoder_standard_state::allocator( sizeof(decoder_standard_state), allocator_page );
#endif

decoder_standard_state::~decoder_standard_state() {
}

// in:
//   1/n throuput 
decoder_standard::decoder_standard(unsigned An) {
  n = An;
  nbit = 0;
  sbit = false;
}

decoder_standard::~decoder_standard() {
}

void decoder_standard::put(bool bit) {
  PRECONDITION( empty() );
  ++nbit;
  if (bit) 
    sbit = !sbit;
}

void decoder_standard::close() {
}
  
bool decoder_standard::get() {
  PRECONDITION( !empty() );
  nbit = 0;
  return sbit;
}
    
bool decoder_standard::empty() const {  
  PRECONDITION( nbit <= n );
  return nbit != n;
}

state* decoder_standard::tell() const {
  decoder_standard_state* s = new decoder_standard_state;
  s->sbit = sbit;
  s->nbit = nbit;
  return s;
}

void decoder_standard::seek(const state* s) {
  sbit = ((const decoder_standard_state*)s)->sbit;
  nbit = ((const decoder_standard_state*)s)->nbit;
}
