// $Log: letter.cc,v $
// Revision 1.3  1997/09/03 07:12:32  am
// Nuova gestione a stream di caratteri
//
// Revision 1.2  1997/08/26 15:59:02  am
// Inclusione condizionale di config.h
//
// Revision 1.1  1997/06/12 19:01:12  am
// Initial revision
//

#if !defined( __MSDOS__ )
#include <config.h>
#endif

#include <string.h>
#include <ctype.h>
#include <debug.h>

#include <vector>

#include <letter.h>

// ---------------------------------------------------------------------------
// iletterstream

iletterstream::iletterstream(istream& Ais) : is(Ais) {
  pred_space = false;
  next_extract();
}

void iletterstream::next_extract() {
  int c = is.get();
  if (c!= EOF && isspace(c)) c = ' ';
  while (!is.bad() && c!=EOF && (c==' ' && pred_space)) {
    c = is.get();
    if (c!=EOF && isspace(c)) c = ' ';
  }
  if (is.bad()) {
    ERROR( "input bad" );
  }
  pred_space = c == ' ';
  if (c != EOF) {
    next = c;
    next_ok = true;
  } else {
    next_ok = false;
    PRECONDITION( is.eof() );
  }
}

bool iletterstream::eof() {
  return !next_ok;
}

char iletterstream::get() {
  PRECONDITION( next_ok );
  char c = next;
  next_extract();
  return c;
}

// ---------------------------------------------------------------------------
// ilstream

ilstream::ilstream(istream& Ais, const alpha& Aalp) 
  : is(Ais), alp( Aalp ) {
}

bool ilstream::eof() {
  return is.eof();
}

element_index ilstream::get() {
  char c = is.get();
  pair<bool,element_index> i = alp.find( c );  
  if (!i.first) {
    ERROR( "unknow element" );
  }
  return i.second;
}

// ---------------------------------------------------------------------------
// ilistream

ilistream::ilistream(istream& Ais, alpha& Aalp) 
  : is(Ais), alp( Aalp ) {
}

bool ilistream::eof() {
  return is.eof();
}

element_index ilistream::get() {
  return alp.insert( is.get() );
}

// ---------------------------------------------------------------------------
// otstream

olstream::olstream(ocstream& Aos, const alpha& Aalp) :
  os(Aos), alp(Aalp) {
}

void olstream::put(element_index A) {
  const char* s = alp[A];
  PRECONDITION( strlen( s ) == 1 );
  os.put( s[0] );
}

void olstream::flush() {
  os.flush();
}
  
// ---------------------------------------------------------------------------
// dictionary_letter

dictionary_letter::dictionary_letter() {
}

dictionary_letter::~dictionary_letter() {
}

void dictionary_letter::make_seeds() {
  // cancella il contenuto attuale
  seeds.erase( seeds.begin(), seeds.end() );
  
  vector<context_next*> tab;
  unsigned n = context::n_get();
  
  // spazio-upper-lower-....
  if (n>=3 && tab.size()==0) {
    for(context_next_set::const_iterator i = diz.begin();i!=diz.end();++i) {
      if ( isspace( *alp[(*i).index_forward_get(0)]) &&
	   isupper( *alp[(*i).index_forward_get(1)]) &&
	   islower( *alp[(*i).index_forward_get(2)]) ) 
        tab.push_back( (context_next*)&*i );
    }
  }
  
  // spazio-upper-....
  if (n>=2 && tab.size()==0) {
    for(context_next_set::const_iterator i = diz.begin();i!=diz.end();++i) {
      if ( isspace( *alp[(*i).index_forward_get(0)]) &&
	   isupper( *alp[(*i).index_forward_get(1)]) )
        tab.push_back( (context_next*)&*i );
    }
  }
  
  // spazio-lower-....
  if (n>=2 && tab.size()==0) {
    for(context_next_set::const_iterator i = diz.begin();i!=diz.end();++i) {
      if ( isspace( *alp[(*i).index_forward_get(0)]) &&
	   islower( *alp[(*i).index_forward_get(1)]) )
        tab.push_back( (context_next*)&*i );
    }
  }  

  // spazio-....
  if (n>=1 && tab.size()==0) {
    for(context_next_set::const_iterator i = diz.begin();i!=diz.end();++i) {
      if (isspace( *alp[(*i).index_forward_get(0)]) ) 
        tab.push_back( (context_next*)&*i );
    }
  }  
  
  if (tab.size()) {
    for(vector<context_next*>::iterator i = tab.begin();i!=tab.end();++i) {
      for(element_set::iterator j = (*i)->begin();j!=(*i)->end();++j) {
	context c = **i;
	c.index_shift( (*j).index_get() );
	context_next_set::iterator k = diz.find( c );
	PRECONDITION( k != diz.end() );
	seeds.push_back( (context_next*)&*k );
      }
    }
  } else {
    ERROR("dictionary fail, no seed");
  }
}

void dictionary_letter::import(istream& is, unsigned n) {  
  context::n_set( n );
  alp.erase();
  ilistream ist( is, alp );
  diz.import( ist );
  make_seeds();
}

void dictionary_letter::stego(ostream& os, istream& is) {
  ocfstream o1( os );
  ocwrapstream o2( o1 );
  olstream ost( o2, alp );
  
  icfstream i1( is );
  icscramblestream i2( i1 );
  ibstream isb( i2 );
  
  diz.stego( seeds, ost, isb );
}

void dictionary_letter::unstego(ostream& os, istream& is) {
  ilstream ist( is, alp );
  
  ocfstream o1( os );
  ocscramblestream o2( o1 );
  obstream osb( o2 );
  
  diz.unstego( seeds, osb, ist );
}

