// $Log: letter.h,v $
// Revision 1.4  1997/09/05 19:53:06  am
// Eliminato S|LogS| [D[D[D[D[C[4~[C[C
//
// Revision 1.3  1997/09/03 07:12:32  am
// Nuova gestione a stream di caratteri
//
// Revision 1.2  1997/06/12 20:39:14  am
// Aggiunto Log
//

#if !defined( __LETTER_H )
#define  __LETTER_H

#include <mimic.h>

// ---------------------------------------------------------------------------
// iletterstream

// note:
//   elimina spazi multipli
// note:
//   caratteri isspace() converititi in ' '
// note:
//   precondizione !eof per get

class iletterstream {
    istream& is;
    bool pred_space;
    char next;
    bool next_ok;
    void next_extract();
  public:
    iletterstream(istream& Ais);
  
    char get();
    bool eof();
  };

// ---------------------------------------------------------------------------
// ilstream

// input stream per lettere
// note:
//   lettere non nell'alfabeto causano eccezzione
// note:
//   precondizione !eof per get

class ilstream : public iestream {
    iletterstream is;
    const alpha& alp;
  public:
    ilstream(istream& Ais, const alpha& Aalp);
    
    virtual element_index get();
    virtual bool eof();
  };

// ---------------------------------------------------------------------------
// ilistream

// input stream per lettere
// note:
//   caratteri non nell'alfabeto automaticamente inseriti
// note:
//   precondizione !eof per get

class ilistream : public iestream {
    iletterstream is;
    alpha& alp;
  public:
    ilistream(istream& Ais, alpha& Aalp);
    
    virtual element_index get();
    virtual bool eof();
  };

// ---------------------------------------------------------------------------
// otstream

// output stream per lettere

class olstream : public oestream {
    ocstream& os;
    const alpha& alp;
  public:
    olstream(ocstream& Aos, const alpha& Aalp);
  
    virtual void put(element_index c);
    virtual void flush();
  };

// ---------------------------------------------------------------------------
// dictionary_letter

class dictionary_letter : public dictionary {
   virtual void make_seeds();
  
  public:
    dictionary_letter();
    virtual ~dictionary_letter();
  
    virtual void stego(ostream& os, istream& is);
    virtual void unstego(ostream& os, istream& is);
    virtual void import(istream& is, unsigned n);
  };

#endif
