// $Log: model.cc,v $
// Revision 1.7  1997/09/10 09:25:45  am
// Corrette messaggi
//
// Revision 1.6  1997/09/04 21:18:02  am
// Corretti messaggi
//
// Revision 1.5  1997/09/04 19:45:42  am
// Aggiunte ai commenti
//
// Revision 1.4  1997/09/02 21:34:21  am
// put e close non gestiscono piu' la condizione di errore
//
// Revision 1.3  1997/08/26 15:59:02  am
// Inclusione condizionale di config.h
//
// Revision 1.2  1997/06/12 20:35:42  am
// aggiunta limitazione alla profondita' del backtracing
//
// Revision 1.1  1997/06/12 18:59:22  am
// Initial revision
//

#pragma implementation

#if !defined( __MSDOS__ )
#include <config.h>
#endif

#include <model.h>

template <class T> inline T& noconst(const T& A) { return (T&)A; }

// ---------------------------------------------------------------------------
// model

#ifdef HEAP
allocator_fixed model_internal_state::allocator( sizeof(model_internal_state), allocator_page );
#endif

model_internal_state::model_internal_state() {
  cod = 0;
  dec = 0;
  is = 0;
  os = 0;
}
  
model_internal_state::model_internal_state(const model_internal_state& A) {
  cod = A.cod;
  dec = A.dec;
  is = A.is;
  os = A.os;
  symbol_att = A.symbol_att;
  symbol_mac = A.symbol_mac;
  bit_count = A.bit_count;
  
  noconst(A).cod = 0;
  noconst(A).dec = 0;
  noconst(A).is = 0;
  noconst(A).os = 0;
}

model_internal_state& model_internal_state::operator=(const model_internal_state& A) {
  if (cod) delete cod;
  if (dec) delete dec;
  if (is) delete is;
  if (os) delete os;
  
  cod = A.cod;
  dec = A.dec;
  is = A.is;
  os = A.os;
  symbol_att = A.symbol_att;
  symbol_mac = A.symbol_mac;
  
  noconst(A).cod = 0;
  noconst(A).dec = 0;
  noconst(A).is = 0;
  noconst(A).os = 0;
  
  return *this;
}
  
model_internal_state::model_internal_state(state* Acod, state* Adec, 
					   state* Ais, state* Aos, unsigned Abit_count ) {
  cod = Acod;  
  dec = Adec;
  is = Ais;
  os = Aos;
  bit_count = Abit_count;
}

model_internal_state::~model_internal_state() {
  if (cod) delete cod;
  if (dec) delete dec;
  if (is) delete is;
  if (os) delete os;
}

// return:
//   true sono stati emessi tutti i simboli
bool model_internal_state::symbol_end() const {
  return symbol_mac == 2;
}

// inizializza il simbolo
void model_internal_state::symbol_start() {
  // Il simbolo scelto casualmente tra i due possibili
  // I simboli sono equiprobabili
  symbol_att = rand() < (RAND_MAX/2);
  symbol_mac = 0;
}

// Passa al successivo simbolo
// return:
//   ritorna il simbolo precedente (operatore di post-incremento)
bool model_internal_state::symbol_inc() {
  PRECONDITION( !symbol_end() );
  ++symbol_mac;
  bool att = symbol_att;
  symbol_att = !symbol_att;
  return att;
}

// --------------------------------------------------------------------------
// model

// in:
//   Acod coder da utilizzare
//   Adec decoder che sara' utilizzato per decodificare
//   Atimeout_rate
//     numero massimo di iterazioni per ogni bit in uscita', se viene superato
//     la codifica fallisce   
model::model(siobit& Acod, siobit& Adec, unsigned Atimeout_bit_rate) :
  cod(Acod),dec(Adec) {
  timeout_bit_rate = Atimeout_bit_rate;
}

model::~model() {
}

// stack

// massima profondita' in numero di simboli del backtrace
#define MODEL_BACKTRACE_DEPTH_MAX 1024

// inserisce nello stack lo stato attuale
void model::st_push() {
  stt.push_front( model_internal_state( 
	          cod.tell(), dec.tell(), is.tell(), os.tell(), bit_count ) );
  // se troppi stati elimina quello piu' in profondita'
  if (stt.size() > MODEL_BACKTRACE_DEPTH_MAX)
    stt.pop_back();
}

// estrae dallo stack uno stato, non viene assegnato come stato attuale
void model::st_pop() {
  stt.pop_front();
}

// assegna come attuale lo stato che si trova in cima allo stack
void model::st_top_set() {
  const model_internal_state& top = stt.front();
  cod.seek( top.coder_get() );
  dec.seek( top.decoder_get() );
  is.seek( top.is_get() );
  os.seek( top.os_get() );
  bit_count = top.bit_count_get();
}

// elementi nello stack
unsigned model::st_size() const {
  return stt.size();
}

// connect

// connette l'output del coder con l'input del decoder e confronta
// l'uscita del decoder con l'input fornito
// return:
//   true ok
//   false non c'e' corrispondenza
bool model::connect() {
  // passa al decodificatore le informazioni
  while (!cod.empty()) {
    // legge dal codificatore
    bool bit_code = cod.get();
    // manda in output
    os.put( bit_code );
    // manda al decodificatore
    dec.put( bit_code );
    // controlla se la decodifica da l'output desiderato
    while (!dec.empty()) {
      // non c' input da confrontare
      if (is.empty()) return false;
      bool bit_gen = dec.get();
      bool bit_req = is.get();
      ++bit_count;
      // se differiscono fallisce
      if ( bit_gen != bit_req) return false;
    }
  }
  return true;
}

// connette e chiude il coder ed il decoder
bool model::connect_close() {
  PRECONDITION( is.empty() );
  // chiude il codificatore
  cod.close();
  if (!connect()) return false;
  // chiude il decodificatore
  dec.close();
  if (!dec.empty()) return false;
  return true;
}

// iobit

bool model::empty() const {
  return os.empty();
}
  
bool model::get() {
  PRECONDITION( !empty() );
  return os.get();
}

void model::put(bool bit) {
  is.put( bit );
}

// numero minimo di iterazioni 
#define ITERATION_MIN 20000
// frequenza del controllo, scegliere potenza di 2
#define ITERATION_DELTA 8192

void model::close() {
  // chiude buffer di input
  is.close();

  // terminazione con successo
  bool good = false;
  
  // contatore di iterazioni
  timeout_count = 0;
  
  // contatore di bit
  bit_count = 0;
  
  // stato iniziale, memorizzato nello stack
  st_push();
  // inizializza il simbolo, nello stack
  top_symbol_start();

  if (!top_symbol_end()) {
    while (true) {
      // incrementa il numero di iterazioni
      ++timeout_count;
      // controlla solo ogni tanto e non troppo presto
      if (((timeout_count % ITERATION_DELTA) == 0) && (timeout_count > ITERATION_MIN)) {
	// controlla di non aver fatto troppe iterazioni
	if (timeout_count > (unsigned long)timeout_bit_rate * bit_count) {
	  // timeout
	  break;
	}
      }
      // inserisce il simbolo
      cod.put( top_symbol_inc() );
      // connette i flussi di informazioni
      bool fail = !connect();
      // se input terminato chiude 
      if (!fail && is.empty()) {
	fail = !connect_close();
	// ha terminato
	if (!fail) {
	  good = true;
	  break;
	}
      }
      if (!fail) {
	// codifica con successo
	if (top_symbol_end()) {
	  // se non ci sono altre possibilit lo stato viene estratto dallo 
	  // stack in quanto e' inutile salvarlo
	  st_pop();
	}
	// salva il nuovo stato e va avanti
	st_push();
	// inizializza il simbolo, nello stack
	top_symbol_start();
      } else {
	// se sono state provate tutte le possibilit
	if (top_symbol_end()) {
	  // se lo stack non contiene almeno 2 elementi 
	  // non si puo' piu' continuare
	  if (st_size()<2) {
	    break;
	  }
	  // backtrace, elimina dallo stack lo stato che ha portato al ramo morto
	  st_pop();
	  // imposta lo stato precedente, ma con il simbolo successivo in
	  // emissione
	  st_top_set();
	} else {
	  // reimposta lo stato precedente, ma con il simbolo successivo in
	  // emissione
	  st_top_set();
	}
      }
    }
  }
  
  // cancella lo stack
  while (st_size()) st_pop();

  // chiude l'output
  os.close();

  if (!good) {
    ERROR("hash error, try to increase the bit-rate");
  }
}

// return:
//   numero di iterazioni per ogni bit in uscita  
// note:
//   chiamare subito dopo close
double model::iteration_rate_get() const {
  if (bit_count)
    return (double)timeout_count / bit_count;
  else
    return 0;
}

// return:
//   numero di iterazioni effettuate
// note:
//   chiamare subito dopo close
unsigned long model::iteration_get() const {
  return timeout_count;
}
