// $Log: model.h,v $
// Revision 1.5  1997/09/05 19:53:06  am
// Eliminato S|LogS| [D[D[D[D[C[4~[C[C
//
// Revision 1.4  1997/09/02 21:34:21  am
// put e close non gestiscono piu' la condizione di errore
//
// Revision 1.3  1997/06/12 20:39:14  am
// Aggiunto Log
//

#if !defined( __MODEL_H )
#define __MODEL_H

#include <list>

#include <iobit.h>

// ---------------------------------------------------------------------------
// usata internamente da model

class model_internal_state {
    state* cod;
    state* dec;
    state* is;
    state* os;

    // prossimo simbolo codificato
    bool symbol_att;
    // numero di simboli gia' emessi
    unsigned symbol_mac;

    // bit in ingresso processati
    unsigned bit_count;
  
  public:
    model_internal_state();
    model_internal_state(const model_internal_state&);
    ~model_internal_state();
  
    model_internal_state& operator=(const model_internal_state&);
  
    model_internal_state(state* Acod, state* Adec,  
			 state* Ais, state* Aos, unsigned Abit_count);
  
    const state* coder_get() const;
    const state* decoder_get() const;
    const state* is_get() const;
    const state* os_get() const;
  
    void symbol_start();
    bool symbol_inc();
    bool symbol_end() const;

    unsigned bit_count_get() const { return bit_count; }

#ifdef HEAP
    static allocator_fixed allocator;

    void* operator new(size_t size) {
      return allocator.allocate( size );
    }
    void operator delete(void* p) {
      allocator.deallocate( p );
    } 
#endif

    // request for STL 
    void* operator new(size_t, model_internal_state* p) {
      return p;
    }

  };

inline const state* model_internal_state::coder_get() const {
  PRECONDITION( cod );
  return cod;
}
inline const state* model_internal_state::decoder_get() const {
  PRECONDITION( dec );
  return dec;
}
inline const state* model_internal_state::is_get() const {
  PRECONDITION( is );
  return is;
}
inline const state* model_internal_state::os_get() const {
  PRECONDITION( os );
  return os;
}

// ---------------------------------------------------------------------------
// model

class model : public iobit {
    // codificatore e decodificatore
    siobit& cod; 
    siobit& dec;
  
    // input/output 
    iobit_buffer is;
    iobit_buffer os;
  
    // bit in ingresso processati
    unsigned bit_count;

    // massimo numero di iterazioni bit in ingresso
    unsigned timeout_bit_rate;
    // numero di iterazioni
    unsigned long timeout_count;
  
    // stack per gli stati
//    typedef vector<model_internal_state> internal_container;
//    stack<internal_container> stt;
    list<model_internal_state> stt;

    // operazioni sullo stack
    void st_push();
    void st_pop();
    void st_top_set();
    unsigned st_size() const;
  
    bool connect();
    bool connect_close();
  
    // gestione del simbolo sulla cima dello stack
    bool top_symbol_inc();
    void top_symbol_start();
    bool top_symbol_end() const;
  public:
    model(siobit& Acod, siobit& Adec, unsigned Atimeout_rate);

    virtual void put(bool bit);
    virtual void close();

    virtual bool get();
    virtual bool empty() const;  
  
    double iteration_rate_get() const;
    unsigned long iteration_get() const;
  };

inline bool model::top_symbol_inc() {
  return stt.front().symbol_inc();
}

inline void model::top_symbol_start() {
  stt.front().symbol_start();
}

inline bool model::top_symbol_end() const {
  return stt.front().symbol_end();
}

#endif

