// $Log: word.cc,v $
// Revision 1.3  1997/09/03 07:12:32  am
// Nuova gestione a stream di caratteri
//
// Revision 1.2  1997/08/26 15:59:02  am
// Inclusione condizionale di config.h
//
// Revision 1.1  1997/06/12 19:02:04  am
// Initial revision
//
// Revision 1.1  1997/06/12 19:01:37  am
// Initial revision
//

#if !defined( __MSDOS__ )
#include <config.h>
#endif

#include <ctype.h>
#include <string.h>

#include <debug.h>

#include <word.h>

// ---------------------------------------------------------------------------
// iwordstream

iwordstream::iwordstream(istream& Ais) : is(Ais) {
  // valore iniziale dei buffer di parola
  next_max = 128;
  next = new char[next_max];
  last = new char[next_max];
  next_extract();
}

iwordstream::~iwordstream() {
  delete [] next;
  delete [] last;
}

// assicura che ci sia spazio per almeno Amax caratteri
void iwordstream::next_realloc(unsigned Amax) {
  if (Amax >= next_max) {
    // doppio della dimensione
    unsigned Anext_max = next_max * 2;
    PRECONDITION( Anext_max >= Amax );
    char* Anext = new char[Anext_max];
    char* Alast = new char[Anext_max];
    memcpy( Anext, next, next_max );
    memcpy( Alast, last, next_max );
    delete [] next;
    delete [] last;
    next = Anext;
    last = Alast;
    next_max = Anext_max;
  }
}

// carattere punteggiatura
inline bool myispunct(char c) {
  return c>=' ' && c<='~' && ispunct(c);
}

// estrae in next la successiva parola
// out:
//   next successiva parola
//   next_ok next contiene la successiva parola
void iwordstream::next_extract() {
  int c = is.get();
  unsigned l = 0;
  
  if (c != EOF) {
    if (isspace(c)) {
      while (!is.bad() && c!=EOF && isspace(c)) 
        c = is.get();
      if (c!=EOF)
        is.putback(c);
      next_realloc( l+1 );
      next[l] = ' ';
      ++l;
    } else if (myispunct(c)) {
      while (!is.bad() && c!=EOF && myispunct(c)) {
        next_realloc( l+1 );
        next[l] = c;
        ++l;
        c = is.get();
      }
      if (c!=EOF)
        is.putback(c);
    } else {
      while (!is.bad() && c!=EOF && !myispunct(c) && !isspace(c)) {
        next_realloc( l+1 );
        next[l] = c;
        ++l;
        c = is.get();
      }
      if (c!=EOF) 
        is.putback(c);
    }
  }
  if (is.bad()) {
    ERROR( "input bad" );
  }
  
  if (l) {
    next_realloc( l+1 );
    next[l] = 0;
    next_ok = true;
  } else
    next_ok = false;
}

bool iwordstream::eof() {
  return !next_ok;
}

const char* iwordstream::get() {
  PRECONDITION( next_ok );
  // copia la parola
  strcpy( last, next );
  // prossima
  next_extract();
  // ritorna l'ultima
  return last;
}

// ---------------------------------------------------------------------------
// iwstream

iwstream::iwstream(istream& Ais, const alpha& Aalp) :
  is(Ais), alp(Aalp) {
}

element_index iwstream::get() {
  pair<bool,element_index> i = alp.find( is.get() );  
  if (!i.first) {
    ERROR( "unknow element" );
  }
  return i.second;
}
  
bool iwstream::eof() {
  return is.eof();
}
  
// ---------------------------------------------------------------------------
// iwistream

iwistream::iwistream(istream& Ais, alpha& Aalp) :
  is(Ais), alp(Aalp) {
}
    
element_index iwistream::get() {
  return alp.insert( is.get() );
}
  
bool iwistream::eof() {
  return is.eof();
}

// ---------------------------------------------------------------------------
// owstream

owstream::owstream(ocstream& Aos, const alpha& Aalp) :
  os(Aos), alp(Aalp) {
}

void owstream::put(element_index A) {
  const char* s = alp[A];
  while (*s) os.put( *s++ );
}

void owstream::flush() {
  os.flush();
}
						     
// ---------------------------------------------------------------------------
// dictionary_word

dictionary_word::dictionary_word() {
}

dictionary_word::~dictionary_word() {
}

void dictionary_word::make_seeds() {
  // cancella il contenuto attuale
  seeds.erase( seeds.begin(), seeds.end() );
  
  unsigned n = context::n_get();
  
  // upper-lower-....
  if (n>=1 && seeds.size()==0) {
    for(context_next_set::const_iterator i = diz.begin();i!=diz.end();++i) {
      const char* s = alp[ (*i).index_forward_get(0) ];
      if ( isupper( s[0] ) &&
	   islower( s[1] ) )
        seeds.push_back( (context_next*)&*i );
    }
  }
  
  // upper-....
  if (n>=1 && seeds.size()==0) {
    for(context_next_set::const_iterator i = diz.begin();i!=diz.end();++i) {
      const char* s = alp[ (*i).index_forward_get(0) ];
      if ( isupper( s[0] ) )
        seeds.push_back( (context_next*)&*i );
    }
  }
  
  // lower-....
  if (n>=1 && seeds.size()==0) {
    for(context_next_set::const_iterator i = diz.begin();i!=diz.end();++i) {
      const char* s = alp[ (*i).index_forward_get(0) ];
      if ( islower( s[0] ) )
        seeds.push_back( (context_next*)&*i );
    }
  }
  
  if (seeds.size() == 0) {
    ERROR("dictionary fail, no seed");
  }
}

void dictionary_word::import(istream& is, unsigned n) {  
  context::n_set( n );
  alp.erase();
  iwistream ist( is, alp );
  diz.import( ist );
  make_seeds();
}

void dictionary_word::stego(ostream& os, istream& is) {
  // conversione da stream di dati a file
  ocfstream o1( os );
  // wrap 
  ocwrapstream o2( o1 );
  // conversione dal codici a simboli
  owstream ost( o2, alp );
  
  icfstream i1( is );
  icscramblestream i2( i1 );
  ibstream isb( i2 );
  
  diz.stego( seeds, ost, isb );
}

void dictionary_word::unstego(ostream& os, istream& is) {
  iwstream ist( is, alp );
  
  ocfstream o1( os );
  ocscramblestream o2( o1 );
  obstream osb( o2 );
  
  diz.unstego( seeds, osb, ist );
}
