// $Log: word.h,v $
// Revision 1.4  1997/09/05 19:53:06  am
// Eliminato S|LogS| [D[D[D[D[C[4~[C[C
//
// Revision 1.3  1997/09/03 07:12:32  am
// Nuova gestione a stream di caratteri
//
// Revision 1.2  1997/06/12 20:39:14  am
// Aggiunto Log
//

#if !defined( __WORD_H )
#define  __WORD_H

#include <mimic.h>

#include <vector>
#include <map>

// ---------------------------------------------------------------------------
// iwordstream

// input stream di parole
// note:
//   limitazione sulla lunghezza massima a WORD_MAX-1
// note:
//   precondizione !eof per get

class iwordstream {
    istream& is;
  
    // prossima parola ritornata, allocato dinamicamente
    char* next;
    // ultima parola ritornata, allocato dinamicamente
    char* last;
    // spazio allocato
    unsigned next_max;
    // valore in next valido
    bool next_ok;
  
    void next_realloc(unsigned Amax);
    void next_extract();
  public:
    iwordstream(istream& Ais);
    ~iwordstream();
  
    const char* get();
    bool eof();
  };

// ---------------------------------------------------------------------------
// iwstream

// input stream di parole con alfabeto
// note:
//   parole non nell'alfabeto causano eccezzione
// note:
//   precondizione !eof per get

class iwstream : public iestream {
    iwordstream is;
    const alpha& alp;
  public:
    iwstream(istream& Ais, const alpha& Aalp);
    
    virtual element_index get();
    virtual bool eof();
  };

// ---------------------------------------------------------------------------
// iwistream

// input stream di parole con alfabeto
// note:
//   parole non nell'alfabeto automaticamente inserite
// note:
//   precondizione !eof per get

class iwistream : public iestream {
    iwordstream is;
    alpha& alp;
  public:
    iwistream(istream& Ais, alpha& Aalp);
    
    virtual element_index get();
    virtual bool eof();
  };

// ---------------------------------------------------------------------------
// owstream

// output stream di parole

class owstream : public oestream {
    ocstream& os;
    const alpha& alp;
  public:
    owstream(ocstream& Aos, const alpha& Aalp);
  
    virtual void put(element_index c);
    virtual void flush();
  };

// ---------------------------------------------------------------------------
// dictionary_word

class dictionary_word : public dictionary {
    virtual void make_seeds();
  public:
    dictionary_word();
    virtual ~dictionary_word();
  
    virtual void stego(ostream& os, istream& is);
    virtual void unstego(ostream& os, istream& is);
    virtual void import(istream& is, unsigned n);  
  };

#endif
