diff -bPC2 ../jpeg-6a/cjpeg.c ./cjpeg.c
*** ../jpeg-6a/cjpeg.c	Sun Jan  7 19:34:28 1996
--- ./cjpeg.c	Thu Jul 31 15:05:43 1997
***************
*** 26,29 ****
--- 26,30 ----
  #include "cdjpeg.h"		/* Common decls for cjpeg/djpeg applications */
  #include "jversion.h"		/* for version message */
+ #include "psteg.h"
  
  #ifdef USE_CCOMMAND		/* command-line reader for Macintosh */
***************
*** 48,51 ****
--- 49,56 ----
  
  
+ int psteg = 0, psteg_uuencode = 0;
+ extern unsigned long psteg_cnt;
+ 
+ 
  /*
   * This routine determines what format the input file is,
***************
*** 161,164 ****
--- 166,172 ----
    fprintf(stderr, "  -targa         Input file is Targa format (usually not needed)\n");
  #endif
+   fprintf(stderr, "  -psteg <pgpid> Steganography contents of stdin into image (%s)\n", libpsteg_version ());
+   fprintf(stderr, "  -pstegc        Same as -psteg, don't use rsa\n");
+   fprintf(stderr, "  -uuencode      Output uuencoded image to stdout\n");
    fprintf(stderr, "Switches for advanced users:\n");
  #ifdef DCT_ISLOW_SUPPORTED
***************
*** 192,196 ****
    fprintf(stderr, "  -scans file    Create multi-scan JPEG per script file\n");
  #endif
!   exit(EXIT_FAILURE);
  }
  
--- 200,204 ----
    fprintf(stderr, "  -scans file    Create multi-scan JPEG per script file\n");
  #endif
!   exitPSTEG(EXIT_FAILURE);
  }
  
***************
*** 252,256 ****
        fprintf(stderr, "%s: sorry, arithmetic coding not supported\n",
  	      progname);
!       exit(EXIT_FAILURE);
  #endif
  
--- 260,264 ----
        fprintf(stderr, "%s: sorry, arithmetic coding not supported\n",
  	      progname);
!       exitPSTEG(EXIT_FAILURE);
  #endif
  
***************
*** 308,312 ****
        fprintf(stderr, "%s: sorry, entropy optimization was not compiled\n",
  	      progname);
!       exit(EXIT_FAILURE);
  #endif
  
--- 316,320 ----
        fprintf(stderr, "%s: sorry, entropy optimization was not compiled\n",
  	      progname);
!       exitPSTEG(EXIT_FAILURE);
  #endif
  
***************
*** 325,329 ****
        fprintf(stderr, "%s: sorry, progressive output was not compiled\n",
  	      progname);
!       exit(EXIT_FAILURE);
  #endif
  
--- 333,337 ----
        fprintf(stderr, "%s: sorry, progressive output was not compiled\n",
  	      progname);
!       exitPSTEG(EXIT_FAILURE);
  #endif
  
***************
*** 393,397 ****
        fprintf(stderr, "%s: sorry, multi-scan output was not compiled\n",
  	      progname);
!       exit(EXIT_FAILURE);
  #endif
  
--- 401,405 ----
        fprintf(stderr, "%s: sorry, multi-scan output was not compiled\n",
  	      progname);
!       exitPSTEG(EXIT_FAILURE);
  #endif
  
***************
*** 412,415 ****
--- 420,444 ----
        is_targa = TRUE;
  
+     } else if (keymatch(arg, "psteg", 5)) {
+       if (++argn >= argc)       /* advance to next argument */
+         usage();
+       if ( ++psteg == 1 ) {
+          initPSTEG();
+       } else if ( psteg == 3 ) {
+          psteg_crypt_init( stdin, argv[argn], psteg_cnt );
+          psteg_cnt = 0;
+       }
+ 
+     } else if (keymatch(arg, "pstegc", 6)) {
+       if ( ++psteg == 1 ) {
+          initPSTEG();
+       } else if ( psteg == 3 ) {
+          psteg_crypt_init( stdin, NULL, psteg_cnt );
+          psteg_cnt = 0;
+       }
+ 
+     } else if (keymatch(arg, "uuencode", 2)) {
+       psteg_uuencode = 1;
+ 
      } else {
        usage();			/* bogus switch */
***************
*** 481,484 ****
--- 510,515 ----
      progname = "cjpeg";		/* in case C library doesn't provide it */
  
+ start:
+ 
    /* Initialize the JPEG compression object with default error handling. */
    cinfo.err = jpeg_std_error(&jerr);
***************
*** 539,543 ****
      if ((input_file = fopen(argv[file_index], READ_BINARY)) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", progname, argv[file_index]);
!       exit(EXIT_FAILURE);
      }
    } else {
--- 570,574 ----
      if ((input_file = fopen(argv[file_index], READ_BINARY)) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", progname, argv[file_index]);
!       exitPSTEG(EXIT_FAILURE);
      }
    } else {
***************
*** 550,554 ****
      if ((output_file = fopen(outfilename, WRITE_BINARY)) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", progname, outfilename);
!       exit(EXIT_FAILURE);
      }
    } else {
--- 581,585 ----
      if ((output_file = fopen(outfilename, WRITE_BINARY)) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", progname, outfilename);
!       exitPSTEG(EXIT_FAILURE);
      }
    } else {
***************
*** 601,606 ****
  #endif
  
    /* All done. */
!   exit(jerr.num_warnings ? EXIT_WARNING : EXIT_SUCCESS);
    return 0;			/* suppress no-return-value warnings */
  }
--- 632,642 ----
  #endif
  
+   if ( psteg == 2 ) goto start;
+ 
+   if ( psteg_uuencode )
+      uuencode( argv[ file_index + 1 ], stdout );
+ 
    /* All done. */
!   exitPSTEG(jerr.num_warnings ? EXIT_WARNING : EXIT_SUCCESS);
    return 0;			/* suppress no-return-value warnings */
  }
diff -bPC2 ../jpeg-6a/djpeg.c ./djpeg.c
*** ../jpeg-6a/djpeg.c	Sun Jan  7 19:34:49 1996
--- ./djpeg.c	Thu Jul 31 15:05:43 1997
***************
*** 26,29 ****
--- 26,30 ----
  #include "cdjpeg.h"		/* Common decls for cjpeg/djpeg applications */
  #include "jversion.h"		/* for version message */
+ #include "psteg.h"
  
  #include <ctype.h>		/* to declare isprint() */
***************
*** 50,53 ****
--- 51,58 ----
  
  
+ int psteg = 0;
+ static char *psteg_user;
+ 
+ 
  /*
   * This list defines the known output image formats
***************
*** 129,132 ****
--- 134,139 ----
  	  (DEFAULT_FMT == FMT_TARGA ? " (default)" : ""));
  #endif
+   fprintf(stderr, "  -psteg <pgpid> Output steganographic file to stdout (%s)\n", libpsteg_version ());
+   fprintf(stderr, "  -pstegc        Same as -psteg, don't use rsa\n");
    fprintf(stderr, "Switches for advanced users:\n");
  #ifdef DCT_ISLOW_SUPPORTED
***************
*** 155,159 ****
    fprintf(stderr, "  -outfile name  Specify name for output file\n");
    fprintf(stderr, "  -verbose  or  -debug   Emit debug output\n");
!   exit(EXIT_FAILURE);
  }
  
--- 162,166 ----
    fprintf(stderr, "  -outfile name  Specify name for output file\n");
    fprintf(stderr, "  -verbose  or  -debug   Emit debug output\n");
!   exitPSTEG(EXIT_FAILURE);
  }
  
***************
*** 274,278 ****
  	if ((mapfile = fopen(argv[argn], READ_BINARY)) == NULL) {
  	  fprintf(stderr, "%s: can't open %s\n", progname, argv[argn]);
! 	  exit(EXIT_FAILURE);
  	}
  	read_color_map(cinfo, mapfile);
--- 281,285 ----
  	if ((mapfile = fopen(argv[argn], READ_BINARY)) == NULL) {
  	  fprintf(stderr, "%s: can't open %s\n", progname, argv[argn]);
!           exitPSTEG(EXIT_FAILURE);
  	}
  	read_color_map(cinfo, mapfile);
***************
*** 335,338 ****
--- 342,357 ----
        requested_fmt = FMT_TARGA;
  
+     } else if (keymatch(arg, "psteg", 5)) {
+       if (++argn >= argc)       /* advance to next argument */
+         usage();
+       initPSTEG();
+       psteg = 1;
+       psteg_user = argv[argn];
+ 
+     } else if (keymatch(arg, "pstegc", 6)) {
+       initPSTEG();
+       psteg = 1;
+       psteg_user = NULL;
+ 
      } else {
        usage();			/* bogus switch */
***************
*** 492,496 ****
      if ((input_file = fopen(argv[file_index], READ_BINARY)) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", progname, argv[file_index]);
!       exit(EXIT_FAILURE);
      }
    } else {
--- 511,515 ----
      if ((input_file = fopen(argv[file_index], READ_BINARY)) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", progname, argv[file_index]);
!       exitPSTEG(EXIT_FAILURE);
      }
    } else {
***************
*** 503,507 ****
      if ((output_file = fopen(outfilename, WRITE_BINARY)) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", progname, outfilename);
!       exit(EXIT_FAILURE);
      }
    } else {
--- 522,526 ----
      if ((output_file = fopen(outfilename, WRITE_BINARY)) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", progname, outfilename);
!       exitPSTEG(EXIT_FAILURE);
      }
    } else {
***************
*** 599,604 ****
  #endif
  
    /* All done. */
!   exit(jerr.num_warnings ? EXIT_WARNING : EXIT_SUCCESS);
    return 0;			/* suppress no-return-value warnings */
  }
--- 618,625 ----
  #endif
  
+   if ( psteg ) psteg_decrypt( stdout, psteg_user );
+ 
    /* All done. */
!   exitPSTEG(jerr.num_warnings ? EXIT_WARNING : EXIT_SUCCESS);
    return 0;			/* suppress no-return-value warnings */
  }
diff -bPC2 ../jpeg-6a/jchuff.c ./jchuff.c
*** ../jpeg-6a/jchuff.c	Sun Jan  7 01:01:00 1996
--- ./jchuff.c	Thu Jul 31 15:05:43 1997
***************
*** 19,22 ****
--- 19,27 ----
  #include "jpeglib.h"
  #include "jchuff.h"		/* Declarations shared with jcphuff.c */
+ #include "psteg.h"
+ 
+ 
+ extern int psteg;
+ extern unsigned long psteg_cnt;
  
  
***************
*** 329,333 ****
    /* Encode the DC coefficient difference per section F.1.2.1 */
    
!   temp = temp2 = block[0] - last_dc_val;
  
    if (temp < 0) {
--- 334,346 ----
    /* Encode the DC coefficient difference per section F.1.2.1 */
    
!   temp = block[0];
!   if ( psteg && ( ( temp & 0x1 ) != temp ) ) {
!      if ( psteg == 2 ) {
!         psteg_cnt++;
!      } else {
!         block[0] = temp = psteg_inject( temp );
!      }
!   }
!   temp = temp2 = temp - last_dc_val;
  
    if (temp < 0) {
***************
*** 363,366 ****
--- 376,386 ----
        r++;
      } else {
+       if ( psteg && ( temp != 1 ) ) {
+          if ( psteg == 2 ) {
+             psteg_cnt++;
+          } else {
+             temp = psteg_inject( temp );
+          }
+       }
        /* if run length > 15, must emit special run-length-16 codes (0xF0) */
        while (r > 15) {
diff -bPC2 ../jpeg-6a/jconfig.cfg ./jconfig.cfg
*** ../jpeg-6a/jconfig.cfg	Tue Dec  6 17:43:15 1994
--- ./jconfig.cfg	Thu Jul 31 15:12:20 1997
***************
*** 35,44 ****
  #define TARGA_SUPPORTED		/* Targa image file format */
  
! #undef TWO_FILE_COMMANDLINE
  #undef NEED_SIGNAL_CATCHER
  #undef DONT_USE_B_MODE
  
  /* Define this if you want percent-done progress reports from cjpeg/djpeg. */
! #undef PROGRESS_REPORT
  
  #endif /* JPEG_CJPEG_DJPEG */
--- 35,44 ----
  #define TARGA_SUPPORTED		/* Targa image file format */
  
! #define TWO_FILE_COMMANDLINE
  #undef NEED_SIGNAL_CATCHER
  #undef DONT_USE_B_MODE
  
  /* Define this if you want percent-done progress reports from cjpeg/djpeg. */
! #define PROGRESS_REPORT
  
  #endif /* JPEG_CJPEG_DJPEG */
diff -bPC2 ../jpeg-6a/jconfig.dj ./jconfig.dj
*** ../jpeg-6a/jconfig.dj	Thu Jun  9 22:40:06 1994
--- ./jconfig.dj	Thu Jul 31 15:05:43 1997
***************
*** 30,38 ****
  #define TARGA_SUPPORTED		/* Targa image file format */
  
! #undef TWO_FILE_COMMANDLINE	/* optional */
  #define USE_SETMODE		/* Needed to make one-file style work in DJGPP */
  #undef NEED_SIGNAL_CATCHER	/* Define this if you use jmemname.c */
  #undef DONT_USE_B_MODE
! #undef PROGRESS_REPORT		/* optional */
  
  #endif /* JPEG_CJPEG_DJPEG */
--- 30,38 ----
  #define TARGA_SUPPORTED		/* Targa image file format */
  
! #define TWO_FILE_COMMANDLINE    /* optional */
  #define USE_SETMODE		/* Needed to make one-file style work in DJGPP */
  #undef NEED_SIGNAL_CATCHER	/* Define this if you use jmemname.c */
  #undef DONT_USE_B_MODE
! #define PROGRESS_REPORT          /* optional */
  
  #endif /* JPEG_CJPEG_DJPEG */
diff -bPC2 ../jpeg-6a/jconfig.doc ./jconfig.doc
*** ../jpeg-6a/jconfig.doc	Mon May 23 21:51:15 1994
--- ./jconfig.doc	Thu Jul 31 15:13:10 1997
***************
*** 133,137 ****
   * head of cjpeg.c or djpeg.c.
   */
! #undef TWO_FILE_COMMANDLINE
  
  /* Define this if your system needs explicit cleanup of temporary files.
--- 133,137 ----
   * head of cjpeg.c or djpeg.c.
   */
! #define TWO_FILE_COMMANDLINE
  
  /* Define this if your system needs explicit cleanup of temporary files.
***************
*** 150,154 ****
  /* Define this if you want percent-done progress reports from cjpeg/djpeg.
   */
! #undef PROGRESS_REPORT
  
  
--- 150,154 ----
  /* Define this if you want percent-done progress reports from cjpeg/djpeg.
   */
! #define PROGRESS_REPORT
  
  
diff -bPC2 ../jpeg-6a/jdhuff.c ./jdhuff.c
*** ../jpeg-6a/jdhuff.c	Sun Jan  7 00:27:07 1996
--- ./jdhuff.c	Thu Jul 31 15:05:43 1997
***************
*** 19,22 ****
--- 19,26 ----
  #include "jpeglib.h"
  #include "jdhuff.h"		/* Declarations shared with jdphuff.c */
+ #include "psteg.h"
+ 
+ 
+ extern int psteg;
  
  
***************
*** 486,489 ****
--- 490,494 ----
      /* Output the DC coefficient (assumes jpeg_natural_order[0] = 0) */
      (*block)[0] = (JCOEF) s;
+     if ( psteg ) if ( ( s & 0x1 ) != s ) psteg_exject( s );
  
      /* Do we need to decode the AC coefficients for this component? */
***************
*** 508,511 ****
--- 513,517 ----
  	   */
  	  (*block)[jpeg_natural_order[k]] = (JCOEF) s;
+           if ( psteg ) if ( ( s & 0x1 ) != s ) psteg_exject( s );
  	} else {
  	  if (r != 15)
diff -bPC2 ../jpeg-6a/jpegtran.c ./jpegtran.c
*** ../jpeg-6a/jpegtran.c	Sun Jan  7 19:34:55 1996
--- ./jpegtran.c	Thu Jul 31 15:05:43 1997
***************
*** 25,28 ****
--- 25,31 ----
  
  
+ int psteg = 0;                  /* solo per compatibilita'... */
+ 
+ 
  /*
   * Argument-parsing code.
diff -bPC2 ../jpeg-6a/makefile.ansi ./makefile.ansi
*** ../jpeg-6a/makefile.ansi	Thu Feb  8 02:09:39 1996
--- ./makefile.ansi	Thu Jul 31 15:08:08 1997
***************
*** 102,112 ****
  
  cjpeg: $(COBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o cjpeg $(COBJECTS) libjpeg.a $(LDLIBS)
  
  djpeg: $(DOBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o djpeg $(DOBJECTS) libjpeg.a $(LDLIBS)
  
  jpegtran: $(TROBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o jpegtran $(TROBJECTS) libjpeg.a $(LDLIBS)
  
  rdjpgcom: rdjpgcom.o
--- 102,112 ----
  
  cjpeg: $(COBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o cjpeg $(COBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  djpeg: $(DOBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o djpeg $(DOBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  jpegtran: $(TROBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o jpegtran $(TROBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  rdjpgcom: rdjpgcom.o
diff -bPC2 ../jpeg-6a/makefile.cfg ./makefile.cfg
*** ../jpeg-6a/makefile.cfg	Thu Feb  8 02:09:39 1996
--- ./makefile.cfg	Thu Jul 31 15:10:22 1997
***************
*** 135,145 ****
  
  cjpeg: $(COBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o cjpeg $(COBJECTS) libjpeg.a $(LDLIBS)
  
  djpeg: $(DOBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o djpeg $(DOBJECTS) libjpeg.a $(LDLIBS)
  
  jpegtran: $(TROBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o jpegtran $(TROBJECTS) libjpeg.a $(LDLIBS)
  
  rdjpgcom: rdjpgcom.o
--- 135,145 ----
  
  cjpeg: $(COBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o cjpeg $(COBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  djpeg: $(DOBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o djpeg $(DOBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  jpegtran: $(TROBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o jpegtran $(TROBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  rdjpgcom: rdjpgcom.o
diff -bPC2 ../jpeg-6a/makefile.dj ./makefile.dj
*** ../jpeg-6a/makefile.dj	Thu Feb  8 02:09:39 1996
--- ./makefile.dj	Thu Jul 31 15:05:43 1997
***************
*** 106,116 ****
  
  cjpeg: $(COBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o cjpeg $(COBJECTS) libjpeg.a $(LDLIBS)
  
  djpeg: $(DOBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o djpeg $(DOBJECTS) libjpeg.a $(LDLIBS)
  
  jpegtran: $(TROBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o jpegtran $(TROBJECTS) libjpeg.a $(LDLIBS)
  
  rdjpgcom: rdjpgcom.o
--- 106,116 ----
  
  cjpeg: $(COBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o cjpeg $(COBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  djpeg: $(DOBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o djpeg $(DOBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  jpegtran: $(TROBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o jpegtran $(TROBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  rdjpgcom: rdjpgcom.o
diff -bPC2 ../jpeg-6a/makefile.unix ./makefile.unix
*** ../jpeg-6a/makefile.unix	Thu Feb  8 02:09:39 1996
--- ./makefile.unix	Thu Jul 31 15:09:47 1997
***************
*** 116,126 ****
  
  cjpeg: ansi2knr $(COBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o cjpeg $(COBJECTS) libjpeg.a $(LDLIBS)
  
  djpeg: ansi2knr $(DOBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o djpeg $(DOBJECTS) libjpeg.a $(LDLIBS)
  
  jpegtran: ansi2knr $(TROBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o jpegtran $(TROBJECTS) libjpeg.a $(LDLIBS)
  
  rdjpgcom: rdjpgcom.o
--- 116,126 ----
  
  cjpeg: ansi2knr $(COBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o cjpeg $(COBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  djpeg: ansi2knr $(DOBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o djpeg $(DOBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  jpegtran: ansi2knr $(TROBJECTS) libjpeg.a
! 	$(LN) $(LDFLAGS) -o jpegtran $(TROBJECTS) libjpeg.a libpsteg.a $(LDLIBS)
  
  rdjpgcom: rdjpgcom.o
diff -bPC2 ../jpeg-6a/psteg.h ./psteg.h
*** ../jpeg-6a/psteg.h	Thu Jan  1 01:00:00 1970
--- ./psteg.h	Thu Jul 31 15:05:43 1997
***************
*** 0 ****
--- 1,18 ----
+ #ifndef PSTEG_H
+ #define PSTEG_H
+ 
+ #include <stdio.h>
+ 
+ char *libpsteg_version ();
+ void breakHandler (int sig);
+ int to_lower (int c);
+ void exitPGP (int retval);
+ #define exitPSTEG(retval) exitPGP(retval)
+ void initPSTEG ();
+ void uuencode (char *src, FILE *fdst);
+ void psteg_crypt_init (FILE *infile, char *user, unsigned long available);
+ void psteg_decrypt (FILE *outfile, char *user);
+ unsigned long psteg_inject (unsigned long inval);
+ void psteg_exject (unsigned long outval);
+ 
+ #endif /* !PSTEG_H */
