diff -PC2 ../pstorig/language.h ./language.h
*** ../pstorig/language.h	Thu Jan  1 01:00:00 1970
--- ./language.h	Fri Mar 28 12:33:10 1997
***************
*** 0 ****
--- 1,3 ----
+ /* sostituisce l'originale language.h del PGP */
+ 
+ #define LANG(x) x
diff -PC2 ../pstorig/makefile ./makefile
*** ../pstorig/makefile	Thu Jan  1 01:00:00 1970
--- ./makefile	Mon Apr  7 14:31:18 1997
***************
*** 0 ****
--- 1,81 ----
+ CC=gcc
+ AR=ar rc
+ RM=del
+ OPT=-O3
+ CFLAGS=-DMSDOS -DBIOSKEY -DPORTABLE -DNO_ASM -DIDEA32 $(OPT) -c
+ LDFLAGS=
+ EXT=.exe
+ 
+ all: libpsteg.a pcrypt$(EXT) wavpsteg$(EXT)
+ 
+ clean:
+ 	$(RM) *.o
+ 	$(RM) pcrypt.exe
+ 	$(RM) wavpsteg.exe
+ 	$(RM) libpsteg.a
+ 	$(RM) psteg.pat
+ 
+ diff: clean
+ 	diff -PC2 ../pstorig . > psteg.pat
+ 
+ OBJ1=psteg.o idea.o md5.o mpiio.o mpilib.o noise.o
+ OBJ2=passwd.o random.o randpool.o rsaglue1.o system.o
+ OBJ3=zbits.o zdeflate.o zfile_io.o zglobals.o
+ OBJ4=zinflate.o zip.o zipup.o ztrees.o zunzip.o
+ LIBOBJ=$(OBJ1) $(OBJ2) $(OBJ3) $(OBJ4)
+ 
+ libpsteg.a: $(LIBOBJ)
+ 	echo libpsteg.a > lnk.rsp
+ 	echo $(OBJ1) >> lnk.rsp
+ 	echo $(OBJ2) >> lnk.rsp
+ 	echo $(OBJ3) >> lnk.rsp
+ 	echo $(OBJ4) >> lnk.rsp
+ 	$(AR) @lnk.rsp
+ 	del lnk.rsp
+ 
+ pcrypt$(EXT):
+ 	$(CC) $(LDFLAGS) -L. -opcrypt pcrypt.o -lpsteg
+ 	strip -s pcrypt
+ 	stubify pcrypt
+ 	del pcrypt
+ 
+ wavpsteg$(EXT):
+ 	$(CC) $(LDFLAGS) -L. -owavpsteg wavpsteg.o -lpsteg
+ 	strip -s wavpsteg
+ 	stubify wavpsteg
+ 	del wavpsteg
+ 
+ .c.o:
+ 	$(CC) $(CFLAGS) $<
+ 
+ pcrypt$(EXT):	pcrypt.o libpsteg.a
+ wavpsteg$(EXT): wavpsteg.o libpsteg.a
+ pcrypt.o:	pcrypt.c psteg.h
+ wavpsteg.o:	wavpsteg.c psteg.h
+ psteg.o:	psteg.c psteg.h idea.h md5.h mpilib.h rsaglue.h \
+ 		zipup.h zunzip.h
+ idea.o: 	idea.c idea.h usuals.h randpool.h
+ md5.o:		md5.c md5.h
+ mpiio.o:	mpiio.c mpilib.h usuals.h platform.h mpiio.h pgp.h more.h \
+ 		armor.h
+ mpilib.o:	mpilib.c mpilib.h usuals.h platform.h
+ noise.o:	noise.c usuals.h randpool.h noise.h
+ passwd.o:	passwd.c random.h idea.h usuals.h md5.h language.h pgp.h \
+ 		more.h armor.h
+ random.o:	random.c system.h idea.h usuals.h md5.h noise.h language.h \
+ 		random.h fileio.h pgp.h more.h armor.h randpool.h
+ randpool.o:	randpool.c randpool.h usuals.h md5.h
+ rsaglue1.o:	rsaglue1.c mpilib.h usuals.h platform.h mpiio.h pgp.h \
+ 		more.h armor.h rsaglue.h random.h idea.h
+ system.o:	system.c system.h usuals.h mpilib.h
+ zbits.o:	zbits.c zip.h ztailor.h ziperr.h
+ zdeflate.o:	zdeflate.c zunzip.h usuals.h system.h zip.h ztailor.h \
+ 		ziperr.h
+ zfile_io.o:	zfile_io.c zunzip.h usuals.h system.h
+ zglobals.o:	zglobals.c zip.h ztailor.h ziperr.h
+ zinflate.o:	zinflate.c zunzip.h usuals.h system.h exitpgp.h
+ zip.o:		zip.c zip.h usuals.h fileio.h language.h pgp.h more.h \
+ 		armor.h exitpgp.h ziperr.h
+ zipup.o:	zipup.c zip.h ztailor.h ziperr.h zrevisio.h
+ ztrees.o:	ztrees.c zip.h ztailor.h ziperr.h
+ zunzip.o:	zunzip.c zunzip.h usuals.h system.h language.h
diff -PC2 ../pstorig/makefile.dos ./makefile.dos
*** ../pstorig/makefile.dos	Thu Jan  1 01:00:00 1970
--- ./makefile.dos	Mon Apr  7 14:31:26 1997
***************
*** 0 ****
--- 1,81 ----
+ CC=gcc
+ AR=ar rc
+ RM=del
+ OPT=-O3
+ CFLAGS=-DMSDOS -DBIOSKEY -DPORTABLE -DNO_ASM -DIDEA32 $(OPT) -c
+ LDFLAGS=
+ EXT=.exe
+ 
+ all: libpsteg.a pcrypt$(EXT) wavpsteg$(EXT)
+ 
+ clean:
+ 	$(RM) *.o
+ 	$(RM) pcrypt.exe
+ 	$(RM) wavpsteg.exe
+ 	$(RM) libpsteg.a
+ 	$(RM) psteg.pat
+ 
+ diff: clean
+ 	diff -PC2 ../pstorig . > psteg.pat
+ 
+ OBJ1=psteg.o idea.o md5.o mpiio.o mpilib.o noise.o
+ OBJ2=passwd.o random.o randpool.o rsaglue1.o system.o
+ OBJ3=zbits.o zdeflate.o zfile_io.o zglobals.o
+ OBJ4=zinflate.o zip.o zipup.o ztrees.o zunzip.o
+ LIBOBJ=$(OBJ1) $(OBJ2) $(OBJ3) $(OBJ4)
+ 
+ libpsteg.a: $(LIBOBJ)
+ 	echo libpsteg.a > lnk.rsp
+ 	echo $(OBJ1) >> lnk.rsp
+ 	echo $(OBJ2) >> lnk.rsp
+ 	echo $(OBJ3) >> lnk.rsp
+ 	echo $(OBJ4) >> lnk.rsp
+ 	$(AR) @lnk.rsp
+ 	del lnk.rsp
+ 
+ pcrypt$(EXT):
+ 	$(CC) $(LDFLAGS) -L. -opcrypt pcrypt.o -lpsteg
+ 	strip -s pcrypt
+ 	stubify pcrypt
+ 	del pcrypt
+ 
+ wavpsteg$(EXT):
+ 	$(CC) $(LDFLAGS) -L. -owavpsteg wavpsteg.o -lpsteg
+ 	strip -s wavpsteg
+ 	stubify wavpsteg
+ 	del wavpsteg
+ 
+ .c.o:
+ 	$(CC) $(CFLAGS) $<
+ 
+ pcrypt$(EXT):	pcrypt.o libpsteg.a
+ wavpsteg$(EXT): wavpsteg.o libpsteg.a
+ pcrypt.o:	pcrypt.c psteg.h
+ wavpsteg.o:	wavpsteg.c psteg.h
+ psteg.o:	psteg.c psteg.h idea.h md5.h mpilib.h rsaglue.h \
+ 		zipup.h zunzip.h
+ idea.o: 	idea.c idea.h usuals.h randpool.h
+ md5.o:		md5.c md5.h
+ mpiio.o:	mpiio.c mpilib.h usuals.h platform.h mpiio.h pgp.h more.h \
+ 		armor.h
+ mpilib.o:	mpilib.c mpilib.h usuals.h platform.h
+ noise.o:	noise.c usuals.h randpool.h noise.h
+ passwd.o:	passwd.c random.h idea.h usuals.h md5.h language.h pgp.h \
+ 		more.h armor.h
+ random.o:	random.c system.h idea.h usuals.h md5.h noise.h language.h \
+ 		random.h fileio.h pgp.h more.h armor.h randpool.h
+ randpool.o:	randpool.c randpool.h usuals.h md5.h
+ rsaglue1.o:	rsaglue1.c mpilib.h usuals.h platform.h mpiio.h pgp.h \
+ 		more.h armor.h rsaglue.h random.h idea.h
+ system.o:	system.c system.h usuals.h mpilib.h
+ zbits.o:	zbits.c zip.h ztailor.h ziperr.h
+ zdeflate.o:	zdeflate.c zunzip.h usuals.h system.h zip.h ztailor.h \
+ 		ziperr.h
+ zfile_io.o:	zfile_io.c zunzip.h usuals.h system.h
+ zglobals.o:	zglobals.c zip.h ztailor.h ziperr.h
+ zinflate.o:	zinflate.c zunzip.h usuals.h system.h exitpgp.h
+ zip.o:		zip.c zip.h usuals.h fileio.h language.h pgp.h more.h \
+ 		armor.h exitpgp.h ziperr.h
+ zipup.o:	zipup.c zip.h ztailor.h ziperr.h zrevisio.h
+ ztrees.o:	ztrees.c zip.h ztailor.h ziperr.h
+ zunzip.o:	zunzip.c zunzip.h usuals.h system.h language.h
diff -PC2 ../pstorig/makefile.lin ./makefile.lin
*** ../pstorig/makefile.lin	Thu Jan  1 01:00:00 1970
--- ./makefile.lin	Mon Apr  7 14:30:06 1997
***************
*** 0 ****
--- 1,65 ----
+ CC=gcc
+ AR=ar rc
+ RM=rm -f
+ OPT=-O3
+ CFLAGS=-DUNIX -DLINUX -DPORTABLE -DNO_ASM -DIDEA32 $(OPT) -c
+ LDFLAGS=
+ EXT=
+ 
+ all: libpsteg.a pcrypt$(EXT) wavpsteg$(EXT)
+ 
+ clean:
+ 	$(RM) *.o pcrypt wavpsteg libpsteg.a psteg.pat
+ 
+ diff: clean
+ 	diff -PC2 ../pstorig . > psteg.pat
+ 
+ OBJ1=psteg.o idea.o md5.o mpiio.o mpilib.o noise.o
+ OBJ2=passwd.o random.o randpool.o rsaglue1.o system.o
+ OBJ3=zbits.o zdeflate.o zfile_io.o zglobals.o
+ OBJ4=zinflate.o zip.o zipup.o ztrees.o zunzip.o
+ LIBOBJ=$(OBJ1) $(OBJ2) $(OBJ3) $(OBJ4)
+ 
+ libpsteg.a: $(LIBOBJ)
+ 	$(AR) libpsteg.a $(LIBOBJ)
+ 
+ pcrypt$(EXT):
+ 	$(CC) $(LDFLAGS) -L. -opcrypt pcrypt.o -lpsteg
+ 
+ wavpsteg$(EXT):
+ 	$(CC) $(LDFLAGS) -L. -owavpsteg wavpsteg.o -lpsteg
+ 
+ .c.o:
+ 	$(CC) $(CFLAGS) $<
+ 
+ pcrypt$(EXT):	pcrypt.o libpsteg.a
+ wavpsteg$(EXT): wavpsteg.o libpsteg.a
+ pcrypt.o:	pcrypt.c psteg.h
+ wavpsteg.o:	wavpsteg.c psteg.h
+ psteg.o:	psteg.c psteg.h idea.h md5.h mpilib.h rsaglue.h \
+ 		zipup.h zunzip.h
+ idea.o: 	idea.c idea.h usuals.h randpool.h
+ md5.o:		md5.c md5.h
+ mpiio.o:	mpiio.c mpilib.h usuals.h platform.h mpiio.h pgp.h more.h \
+ 		armor.h
+ mpilib.o:	mpilib.c mpilib.h usuals.h platform.h
+ noise.o:	noise.c usuals.h randpool.h noise.h
+ passwd.o:	passwd.c random.h idea.h usuals.h md5.h language.h pgp.h \
+ 		more.h armor.h
+ random.o:	random.c system.h idea.h usuals.h md5.h noise.h language.h \
+ 		random.h fileio.h pgp.h more.h armor.h randpool.h
+ randpool.o:	randpool.c randpool.h usuals.h md5.h
+ rsaglue1.o:	rsaglue1.c mpilib.h usuals.h platform.h mpiio.h pgp.h \
+ 		more.h armor.h rsaglue.h random.h idea.h
+ system.o:	system.c system.h usuals.h mpilib.h
+ zbits.o:	zbits.c zip.h ztailor.h ziperr.h
+ zdeflate.o:	zdeflate.c zunzip.h usuals.h system.h zip.h ztailor.h \
+ 		ziperr.h
+ zfile_io.o:	zfile_io.c zunzip.h usuals.h system.h
+ zglobals.o:	zglobals.c zip.h ztailor.h ziperr.h
+ zinflate.o:	zinflate.c zunzip.h usuals.h system.h exitpgp.h
+ zip.o:		zip.c zip.h usuals.h fileio.h language.h pgp.h more.h \
+ 		armor.h exitpgp.h ziperr.h
+ zipup.o:	zipup.c zip.h ztailor.h ziperr.h zrevisio.h
+ ztrees.o:	ztrees.c zip.h ztailor.h ziperr.h
+ zunzip.o:	zunzip.c zunzip.h usuals.h system.h language.h
diff -PC2 ../pstorig/pcrypt.c ./pcrypt.c
*** ../pstorig/pcrypt.c	Thu Jan  1 01:00:00 1970
--- ./pcrypt.c	Fri Mar 28 12:32:38 1997
***************
*** 0 ****
--- 1,101 ----
+ /*
+  * pcrypt.c
+  *
+  * Un semplice programma di crittografia a chiave pubblica, che illustra il
+  * modo di utilizzo della libreria psteg per la realizzazione di programmi
+  * steganografici.
+  */
+ 
+ 
+ 
+ #include <stdio.h>
+ #include <stdlib.h>
+ #include <string.h>
+ #include "psteg.h"
+ 
+ 
+ 
+ /* la seguente funzione emula il meccanismo di iniezione bit a bit:
+    nella prima fase vengono inizializzate le strutture, creata la chiave di
+    sessione e letto il file in memoria.
+    nella seconda fase (ciclo while) si crea il file crittato;
+    notare che in questa soluzione si tende a ottenere un file 'sparso',
+    poiche' "c << 1" ha 0 come bit meno significativo e psteg_inject tende
+    a lasciarlo inalterato; per ottenere un file piu' bilanciato
+    occorrerebbe settare il bit meno significativo con 0 o 1 a caso.
+    ovviamente questo problema non sussiste quando si impiega il sistema
+    in ambito steganografico.
+    notare che in questo esempio si fornisce 0xffffffff come terzo parametro
+    di psteg_crypt_init(), in quanto non abbiamo limiti superiori di
+    disponibilita'.
+  */
+ 
+ static void rnd_perm_crypt (FILE *infile, FILE *outfile, char *user)
+ {
+    extern unsigned long psteg_cnt, psteg_NN;
+    extern unsigned rsacnt, rsabits;
+    int c = 0, i = 0;
+ 
+    psteg_crypt_init (infile, user, 0xffffffff);
+ 
+    while ( ( psteg_cnt < psteg_NN ) || ( rsacnt < rsabits ) ) {
+       c = psteg_inject ( c << 1 );
+       if ( ++i == 8 ) {
+          putc (c, outfile);
+          c = i = 0;
+       }
+    }
+ }
+ 
+ /* la seguente funzione emula il meccanismo di espulsione bit a bit:
+    nella prima fase (ciclo while) viene copiato infile in tempFile;
+    il bit espulso e' il bit meno significativo del parametro di psteg_exject.
+    nella seconda fase viene decrittato tempFile
+  */
+ 
+ static void rnd_perm_decrypt (FILE *infile, FILE *outfile, char *user)
+ {
+    int c, i;
+ 
+    while ( ( c = getc (infile) ) != EOF )
+       for ( i = 0; i < 8 ; i++ ) {
+          psteg_exject ( c >> 7 );
+          c <<= 1;
+       }
+ 
+    psteg_decrypt (outfile, user);
+ }
+ 
+ static void usage ()
+ {
+    fprintf (stderr, "pcrypt (%s)\n", libpsteg_version ());
+    fprintf (stderr, "usage:\n");
+    fprintf (stderr, "  pcrypt e [ <pgp-id> ]\n");
+    fprintf (stderr, "  pcrypt d [ <pgp-id> ]\n");
+    exitPSTEG (1);
+ }
+ 
+ void main (int argc, char **argv)
+ {
+    int op = 0;
+ 
+    if ( ( argc < 2 ) || ( argc > 3 ) ) usage ();
+ 
+    if ( !strcmp (argv [1], "e") ) op = 1;
+    if ( !strcmp (argv [1], "E") ) op = 1;
+    if ( !strcmp (argv [1], "d") ) op = 2;
+    if ( !strcmp (argv [1], "D") ) op = 2;
+    if ( !op ) usage ();
+ 
+    /* inizializzare sempre prima di chiamare qualsiasi altra funzione */
+    initPSTEG ();
+ 
+    if ( op == 1 )
+       rnd_perm_crypt   (stdin, stdout, (argc == 2) ? NULL : argv [2]);
+    else
+       rnd_perm_decrypt (stdin, stdout, (argc == 2) ? NULL : argv [2]);
+ 
+    /* uscire sempre utilizzando exitPSTEG */
+    exitPSTEG (0);
+ }
+ 
diff -PC2 ../pstorig/psteg.c ./psteg.c
*** ../pstorig/psteg.c	Thu Jan  1 01:00:00 1970
--- ./psteg.c	Wed Apr 16 16:15:00 1997
***************
*** 0 ****
--- 1,864 ----
+ #include <stdlib.h>
+ #include <stdio.h>
+ #include <string.h>
+ #ifdef MSDOS
+ #include <io.h>
+ #include <fcntl.h>
+ #endif
+ #include "psteg.h"
+ #include "idea.h"
+ #include "md5.h"
+ #include "mpilib.h"
+ #include "rsaglue.h"
+ #include "zipup.h"
+ #include "zunzip.h"
+ 
+ 
+ 
+ typedef union {
+    unsigned char kc [16];
+    unsigned long kl [4];
+ } KEY;
+ 
+ typedef union {
+    unsigned char kc [6];
+    struct {
+       unsigned long key;
+       unsigned      index;
+    } ks;
+ } KEY_PLUS_INDEX;
+ 
+ 
+ 
+ char globalRandseedName [256];
+ FILE *pgpout = stderr;
+ unsigned char quietmode = 0;
+ unsigned char filter_mode = 0;
+ #ifndef MSDOS
+ unsigned char verbose = 0;
+ #endif
+ extern short global_precision;
+ 
+ 
+ 
+ #define areapnt unsigned char *
+ #define LENSIZE 4         /* spazio riservato per memorizzare la lunghezza */
+ 
+ 
+ 
+ static char *version_descr = "libpsteg v1.2b";
+ static unsigned mpi_checksum;
+ static char *rndname = "randseed.bin";
+ static char *tmpname = "__temp__";
+ static char *warn_ring_not_found =
+ #ifdef MSDOS
+    "Can't find secring.pgp or pubring.pgp in $PGPPATH or C:\\PGP\n";
+ #else
+    "Can't find secring.pgp or pubring.pgp in $PGPPATH or ~/.pgp\n";
+ #endif
+ static char *warn_bad_hex_key =
+    "Hex key id given with invalid digits.\n";
+ static char *warn_need_pass =
+    "You need a pass phrase to unlock your RSA secret key.";
+ static char *warn_no_pass =
+    "No pass phrase; secret key unavailable.\n";
+ static char tempName [256];
+ static char *pgppath = NULL;
+ static char _pgppath [256];
+ static FILE *tempFile = NULL;
+ static unsigned char *psteg_area = NULL;
+ static KEY psteg_key;
+ static unsigned long psteg_n;
+ static unsigned char rsabuf [262];
+ static unsigned psteg_l;
+ unsigned long psteg_NN, psteg_cnt = 0;
+ unsigned rsacnt = 0, rsabits;
+ 
+ 
+ 
+ char *libpsteg_version ()
+ {
+    return version_descr;
+ }
+ 
+ void breakHandler (int sig)
+ {
+    /* per il momento resta non implementato */
+ }
+ 
+ int to_lower (int c)
+ {
+    c &= 0xFF;
+    if (isupper(c))
+       return (tolower(c));
+    return c;
+ }
+ 
+ void exitPGP (int retval)
+ {
+    unsigned long i;
+    int c;
+ 
+    /* brucia la chiave di sessione */
+    for ( c = 0 ; c < 4 ; c++ ) psteg_key.kl [c] = 0;
+ 
+    /* brucia il file temporaneo prima di rimuoverlo */
+    if ( tempFile != NULL ) {
+       fclose (tempFile);
+       tempFile = fopen (tempName, "rb");
+       fseek (tempFile, 0, SEEK_END);
+       i = ftell (tempFile);
+       fclose (tempFile);
+       tempFile = fopen (tempName, "wb");
+       while ( i-- ) putc (0, tempFile);
+       fclose (tempFile);
+       unlink (tempName);
+    }
+ 
+    free ( psteg_area );
+    exit (retval);
+ }
+ 
+ void initPSTEG ()
+ {
+    unsigned char *ptr;
+    FILE *tmp = NULL;
+ 
+ #ifdef MSDOS
+    setmode (fileno(stdin),  O_BINARY);
+    setmode (fileno(stdout), O_BINARY);
+ #endif
+ 
+    ptr = getenv ( "PGPPATH" );
+    if ( ptr ) {
+ #ifdef MSDOS
+       sprintf (globalRandseedName, "%s\\%s", ptr, rndname);
+       tmp = fopen (globalRandseedName, "rb");
+       if ( tmp != NULL ) sprintf (pgppath = _pgppath, "%s\\", ptr);
+ #else
+       sprintf (globalRandseedName, "%s/%s", ptr, rndname);
+       tmp = fopen (globalRandseedName, "rb");
+       if ( tmp != NULL ) sprintf (pgppath = _pgppath, "%s/", ptr);
+ #endif
+    }
+    if ( tmp == NULL ) {
+ #ifdef MSDOS
+       sprintf (globalRandseedName, "c:\\pgp\\%s", rndname);
+       tmp = fopen (globalRandseedName, "rb");
+       if ( tmp != NULL ) sprintf (pgppath = _pgppath, "c:\\pgp\\");
+ #else
+       ptr = getenv ( "HOME" );
+       if ( ptr ) {
+          sprintf (globalRandseedName, "%s/.pgp/%s", ptr, rndname);
+          tmp = fopen (globalRandseedName, "rb");
+          if ( tmp != NULL ) sprintf (pgppath = _pgppath, "%s/.pgp/", ptr);
+       }
+ #endif
+    }
+    if ( tmp != NULL ) fclose (tmp);
+ 
+    ptr = getenv ( "TEMP" );
+    if ( ptr == NULL ) ptr = getenv ( "TMP" );
+    if ( ptr ) {
+ #ifdef MSDOS
+       sprintf (tempName, "%s\\%s", ptr, tmpname);
+ #else
+       sprintf (tempName, "%s/%s", ptr, tmpname);
+ #endif
+       tempFile = fopen (tempName, "wb");
+    }
+    if ( tempFile == NULL ) {
+       sprintf (tempName, tmpname);
+       tempFile = fopen (tempName, "wb");
+    }
+    if ( tempFile == NULL ) {
+       fprintf (stderr, "Can't create temporary file.\n");
+       exitPGP (1);
+    }
+ }
+ 
+ #define uuencode_convert(c) ((c) ? (c) + 32 : '`')
+ #ifdef MSDOS
+ #   define end_of_line "\15\12"
+ #else
+ #   define end_of_line "\12"
+ #endif
+ 
+ void uuencode_expand (char *line, int *pos, unsigned long buf)
+ {
+    line [*pos] = uuencode_convert ( (buf >> 18) & 0x3f ); (*pos)++;
+    line [*pos] = uuencode_convert ( (buf >> 12) & 0x3f ); (*pos)++;
+    line [*pos] = uuencode_convert ( (buf >>  6) & 0x3f ); (*pos)++;
+    line [*pos] = uuencode_convert ( (buf >>  0) & 0x3f ); (*pos)++;
+ }
+ 
+ void uuencode_flush (char *line, int col, FILE *fdst)
+ {
+    line [ ( (col * 4) / 3 ) + ( (col * 4) % 3 ) ] = 0;
+    fprintf (fdst, "%c%s%s", uuencode_convert (col), line, end_of_line);
+ }
+ 
+ void uuencode (char *src, FILE *fdst)
+ {
+    FILE *fsrc;
+    int c;
+    unsigned long buf;
+    char line [61];
+    int pos = 0, col = 0;
+ 
+    fsrc = fopen (src, "rb");
+    if ( fsrc == NULL ) {
+       fprintf (stderr, "i/o error\n");
+       return;
+    }
+ 
+    fprintf (fdst, "begin 644 %s%s", src, end_of_line);
+ 
+    while ( ( c = getc (fsrc) ) != EOF ) {
+       col++;
+       buf = ( buf << 8 ) | c;
+       if ( (col % 3) == 0 ) {
+          uuencode_expand (line, &pos, buf);
+          if ( col == 45 ) {
+             uuencode_flush (line, col, fdst);
+             pos = col = 0;
+          }
+       }
+    }
+    if ( col % 3 ) {
+       for ( c = col; c % 3 ; c++ ) buf <<= 8;
+       uuencode_expand (line, &pos, buf);
+    }
+    if ( pos ) uuencode_flush (line, col, fdst);
+    uuencode_flush (line, 0, fdst);
+    fprintf (fdst, "end%s", end_of_line);
+ 
+    fclose (fsrc);
+ }
+ 
+ static int logaritmo_intero_sopra (unsigned long num)
+ {
+    int l = 0, c = 0;
+ 
+    while ( num > 1 ) {
+       if ( num & 1 ) c = 1;
+       num >>= 1;
+       l++;
+    }
+    return l + c;
+ }
+ 
+ static int logaritmo_intero_sotto (unsigned long num)
+ {
+    int l = 0;
+ 
+    while ( num > 1 ) {
+       num >>= 1;
+       l++;
+    }
+    return l;
+ }
+ 
+ int substr_nocase (char *name, char *user)
+ {
+    char *p;
+    char *q;
+    char c1, c2;
+ 
+    while ( *name ) {
+       p = name;
+       q = user;
+       do {
+          if ( *q == 0 ) return 1;
+          c1 = *p++; if ( (c1 >= 'A') && ( c1 <= 'Z' ) ) c1 += ( 'a' - 'A' );
+          c2 = *q++; if ( (c2 >= 'A') && ( c2 <= 'Z' ) ) c2 += ( 'a' - 'A' );
+       } while ( c1 == c2 );
+       name++;
+    }
+ 
+    return 0;
+ }
+ 
+ static void psteg_set_key (FILE *infile, areapnt dst, unsigned char *user)
+ {
+    struct MD5Context mdContext;
+    int c;
+ 
+    MD5Init (&mdContext);
+    fseek (infile, 0, SEEK_SET);
+    while ( ( c = getc (infile) ) != EOF ) {
+       MD5Update (&mdContext, &c, 1);
+       *dst++ = c;
+    }
+    MD5Final (psteg_key.kc, &mdContext);
+    if ( user == NULL )
+       for ( c = 0 ; c < 16 ; c++ ) *dst++ = psteg_key.kc [c];
+ }
+ 
+ static int psteg_final_check (areapnt buf, unsigned long length,
+                                 unsigned char *user)
+ {
+    struct MD5Context mdContext;
+    unsigned char md [16];
+    unsigned long i;
+    int c;
+ 
+    if ( (length > psteg_n - LENSIZE) || (length == 0) ) return 1;
+    MD5Init (&mdContext);
+    for ( i = 0 ; i < length ; i++ ) {
+       putc (c = *buf++, tempFile);
+       MD5Update (&mdContext, &c, 1);
+    }
+    MD5Final (md, &mdContext);
+ 
+    if ( user ) {
+       for ( c = 0 ; c < 16 ; c++ )
+          if ( md [c] != psteg_key.kc [c] ) return 1;
+    } else {
+       for ( c = 0 ; c < 16 ; c++ )
+          if ( md [c] != *buf++ ) return 1;
+    }
+ 
+    return 0;
+ }
+ 
+ static unsigned int rnd_func_gen (KEY_PLUS_INDEX *k)
+ {
+    struct MD5Context mdContext;
+    union {
+       unsigned char dc[16];
+       unsigned      result;
+    } digest;
+ 
+    MD5Init (&mdContext);
+    MD5Update (&mdContext, k->kc, 6);
+    MD5Final (digest.dc, &mdContext);
+ 
+    return digest.result;
+ }
+ 
+ #define trunc_index(index,length) \
+                 (index & (((unsigned int)(0xffff))>>(16-length)))
+ #define xor_trunc(x,y,length) trunc_index((x)^(y),length)
+ 
+ static unsigned long rnd_perm ()
+ {
+    KEY_PLUS_INDEX k;
+    unsigned       lengthL, lengthR, L, R;
+    unsigned long  index;
+ 
+    lengthL = psteg_l >> 1;
+    lengthR = psteg_l - lengthL;
+ 
+    L = trunc_index ((unsigned int)psteg_cnt, lengthL);
+    R = trunc_index ((unsigned int)(psteg_cnt >> lengthL), lengthR);
+ 
+    k.ks.key = psteg_key.kl[0];
+      k.ks.index = R;
+        L = xor_trunc (L, rnd_func_gen (&k), lengthL);
+    k.ks.key = psteg_key.kl[1];
+      k.ks.index = L;
+        R = xor_trunc (R, rnd_func_gen (&k), lengthR);
+    k.ks.key = psteg_key.kl[2];
+      k.ks.index = R;
+        L = xor_trunc (L, rnd_func_gen (&k), lengthL);
+    k.ks.key = psteg_key.kl[3];
+      k.ks.index = L;
+        R = xor_trunc (R, rnd_func_gen (&k), lengthR);
+ 
+    index = R;
+    index <<= lengthL;
+    index |= L;
+ 
+    return index;
+ }
+ 
+ static unsigned long read_packet_length (int c, FILE *f)
+ {
+    static int    bytes [] = { 1, 2, 4, 0 };
+    unsigned long len = 0;
+    int           n;
+ 
+    n = bytes [c & 0x03];
+ 
+    if (!n) return 0x7FFFFFFF;
+ 
+    while ( n-- ) {
+       len <<= 8;
+       len |= getc (f);
+    }
+ 
+    return len;
+ }
+ 
+ static unsigned read_mp (FILE *f, unsigned char *mpi)
+ {
+    unsigned len, i;
+ 
+    mpi [0] = i = getc (f);
+    len = i << 8;
+    mpi_checksum += i;
+    mpi [1] = i = getc (f);
+    len |= i;
+    mpi_checksum += i;
+    len = (len + 7) >> 3;
+    fread (mpi+2, 1, len, f);
+    return len;
+ }
+ 
+ static void checksum_update (unsigned char *buf, unsigned len)
+ {
+    while ( len-- ) mpi_checksum += *buf++;
+ }
+ 
+ static void pgp_open (unsigned char *filename, FILE **rng)
+ {
+    unsigned char *ptr, name [256];
+ 
+    *rng = NULL;
+    if ( pgppath != NULL ) {
+       sprintf (name, "%s%s", pgppath, filename);
+       *rng = fopen(name, "rb");
+    }
+    if ( *rng == NULL ) {
+       fprintf (stderr, warn_ring_not_found);
+       exitPGP (1);
+    }
+ }
+ 
+ static int parse_user (unsigned char *user, unsigned char *hex_id)
+ {
+    unsigned char *ptr;
+    int            c, user_type = 0;
+    unsigned int   i;
+ 
+    if ( strncmp (user, "0x", 2) ) return 0;
+    ptr = hex_id;
+    user += 2;
+    while ( *user && (user_type < 8) ) {
+       i <<= 4;
+       c = tolower ( *user++ );
+       if      (c >= '0' && c <= '9') i |= (c - '0');
+       else if (c >= 'a' && c <= 'f') i |= (c + 10 - 'a');
+       else {
+          fprintf (stderr, warn_bad_hex_key);
+          return -1;
+       }
+       if ( user_type & 1 ) *ptr++ = i;
+       user_type++;
+    }
+    if(*user || ( (user_type != 6) && (user_type != 8) )) {
+       fprintf (stderr, warn_bad_hex_key);
+       return -1;
+    }
+    return (user_type >> 1);
+ }
+ 
+ static void mp_reverse (unsigned char *mpi, unsigned length)
+ {
+    unsigned i;
+    int c;
+ 
+    for ( i = length+2 ; i < 262 ; i++ ) mpi [i] = 0;
+    for ( i = 0 ; i < length >> 1 ; i++ ) {
+       c = mpi [ length + 1 - i ];
+       mpi [ length + 1 - i ] = mpi [ i + 2 ];
+       mpi [ i + 2 ] = c;
+    }
+ }
+ 
+ static int save_sess_key (unsigned char *user)
+ {
+    FILE          *rng;
+    unsigned char  name [256], hex_id [4];
+    int            c, user_type, cycle = 1, found = 0;
+    unsigned int   i, nn, ee;
+    unsigned long  len;
+    unsigned char  n [262], e [262];
+ 
+    /* cerca pubring.pgp */
+ 
+    pgp_open ("pubring.pgp", &rng);
+ 
+    /* consente la specifica di id esadecimali */
+ 
+    if ( ( user_type = parse_user (user, hex_id) ) < 0 ) {
+       fclose (rng);
+       return 0;
+    }
+ 
+    /* scandisce i pacchetti alla ricerca dello user id specificato */
+ 
+    while (cycle && ((c = getc (rng)) != EOF)) {
+       len = read_packet_length (c, rng);
+       c = (c & 0x3F) >> 2;
+       switch (c) {
+ 
+          /* USER ID */
+          case 0x0D:
+             fread (name, 1, len, rng);
+             name [len] = 0;
+             if ( !user_type ) found = substr_nocase (name, user);
+             cycle = !found;
+             break;
+ 
+          /* Public key */
+          case 0x06:
+             fseek (rng, 8, SEEK_CUR);
+             nn = read_mp (rng, n);
+             if ( user_type ) {
+                found = 1;
+                for ( i = 0 ; i < user_type ; i++ )
+                   if ( hex_id [i] != n [2 + nn - user_type + i] ) found = 0;
+             }
+             ee = read_mp (rng, e);
+             break;
+ 
+          default:
+             fseek (rng, len, SEEK_CUR);
+             break;
+       }
+    }
+    fclose (rng);
+    if (!found) return 0;
+ 
+    fprintf (stderr, "Key for user ID: %s\n", name);
+ 
+    mp_reverse (n, nn);
+    mp_reverse (e, ee);
+ 
+    rsabits = n [0] * 256 + n [1];
+    global_precision = rsabits/16;
+    if ( global_precision*16 < rsabits ) global_precision++;
+ 
+    /* salvataggio della chiave */
+ 
+    c = rsa_public_encrypt (rsabuf, psteg_key.kc, 16, e+2, n+2);
+ 
+    if ( c < 0 ) {
+       fprintf (stderr, "Error in RSA-mpi computation.\n");
+       return 0;
+    }
+ 
+    rsabits = ( rsabits + 7 ) >> 3;
+    rsabits <<= 3;
+ 
+    return 1;
+ }
+ 
+ static int load_sess_key (unsigned char *user)
+ {
+    FILE          *rng;
+    unsigned char  name [256], hex_id [4], iv[8], key [16];
+    struct         IdeaCfbContext cfb;
+    int            c, user_type, cycle = 1, found = 0, crypted;
+    unsigned int   i, sum;
+    unsigned long  len;
+    unsigned char  n [262], e [262], d [262], p [262], q [262], u [262];
+    unsigned       nn, ee, dd, pp, qq, uu;
+ 
+    /* cerca secring.pgp */
+ 
+    pgp_open ("secring.pgp", &rng);
+ 
+    /* consente la specifica di id esadecimali */
+ 
+    if ( ( user_type = parse_user (user, hex_id) ) < 0 ) {
+       fclose (rng);
+       return 0;
+    }
+ 
+    /* scandisce i pacchetti alla ricerca dello user id specificato */
+ 
+    while (cycle && ((c = getc (rng)) != EOF)) {
+       len = read_packet_length (c, rng);
+       c = (c & 0x3F) >> 2;
+       switch (c) {
+ 
+          /* USER ID */
+          case 0x0D:
+             fread (name, 1, len, rng);
+             name [len] = 0;
+             if ( !user_type ) found = substr_nocase (name, user);
+             cycle = !found;
+             break;
+ 
+          /* Secret key */
+          case 0x05:
+             fseek (rng, 8, SEEK_CUR);
+             nn = read_mp (rng, n);
+             if ( user_type ) {
+                found = 1;
+                for ( i = 0 ; i < user_type ; i++ )
+                   if ( hex_id [i] != n [2 + nn - user_type + i] ) found = 0;
+             }
+             ee = read_mp (rng, e);
+             crypted = getc (rng);
+             if ( crypted ) fread (iv, 1, 8, rng);
+             mpi_checksum = 0;
+             dd = read_mp (rng, d);
+             pp = read_mp (rng, p);
+             qq = read_mp (rng, q);
+             uu = read_mp (rng, u);
+             sum = getc (rng); sum <<= 8; sum |= getc (rng);
+             break;
+ 
+          default:
+             fseek (rng, len, SEEK_CUR);
+             break;
+       }
+    }
+    fclose (rng);
+    if (!found) return 0;
+ 
+    fprintf (stderr, "Key for user ID: %s\n", name);
+ 
+    if ( crypted ) {
+       fprintf (stderr, warn_need_pass);
+       if (!GetHashedPassPhrase (key, (unsigned char)1)) {
+          fprintf (stderr, warn_no_pass);
+          return 0;
+       }
+       ideaCfbInit (&cfb, key);
+       ideaCfbDecrypt (&cfb, iv, iv, 8);
+       ideaCfbSync (&cfb);
+       ideaCfbDecrypt (&cfb, d+2, d+2, dd);
+       ideaCfbSync (&cfb);
+       ideaCfbDecrypt (&cfb, p+2, p+2, pp);
+       ideaCfbSync (&cfb);
+       ideaCfbDecrypt (&cfb, q+2, q+2, qq);
+       ideaCfbSync (&cfb);
+       ideaCfbDecrypt (&cfb, u+2, u+2, uu);
+       ideaCfbDestroy (&cfb);
+    }
+    checksum_update (d+2, dd);
+    checksum_update (p+2, pp);
+    checksum_update (q+2, qq);
+    checksum_update (u+2, uu);
+    if ( mpi_checksum != sum ) {
+       fprintf (stderr, "Bad pass phrase!\n");
+       return 0;
+    }
+    if ( crypted ) {
+       fprintf (stderr, "Pass phrase is good.\n");
+    }
+ 
+    mp_reverse (e, ee);
+    mp_reverse (d, dd);
+    mp_reverse (p, pp);
+    mp_reverse (q, qq);
+    mp_reverse (u, uu);
+    mp_reverse (n, nn);
+ 
+    rsabits = n [0] * 256 + n [1];
+    global_precision = rsabits/16;
+    if ( global_precision*16 < rsabits ) global_precision++;
+ 
+    fseek (tempFile, 0, SEEK_END);
+    psteg_n = ftell (tempFile);
+    c = ( rsabits + 7 ) >> 3;
+    psteg_n -= (unsigned long) c;
+    psteg_NN = psteg_n << 3;
+    psteg_l = logaritmo_intero_sotto (psteg_NN);
+    psteg_NN = ((unsigned long)1) << psteg_l;
+    psteg_n = psteg_NN >> 3;
+ 
+    fseek (tempFile, psteg_n, SEEK_SET);
+    fread (rsabuf, 1, c, tempFile);
+ 
+    rsa_private_decrypt (psteg_key.kc, rsabuf, e+2, d+2, p+2, q+2, u+2, n+2);
+ 
+    /* brucia tutte le strutture segrete */
+ 
+    for ( c = 0 ; c < 16 ; c++ ) key [c] = 0;
+    for ( c = 0 ; c < 8 ; c++ ) iv [c] = 0;
+    for ( c = 0 ; c < 262 ; c++ ) d [c] = p [c] = q [c] = u [c] = 0;
+ 
+    return 1;
+ }
+ 
+ void psteg_crypt_init (FILE *infile, char *user, unsigned long available)
+ /*
+    se user == NULL, utilizza la crittazione a chiave singola
+  */
+ {
+    unsigned long i;
+    int c;
+ 
+    /* compressione del file */
+    zipup (infile, tempFile);
+    /* controllare eventuali errori di i/o ... */
+    fclose (tempFile);
+    tempFile = fopen (tempName, "rb");
+ 
+    /* calcolo della lunghezza del file */
+    fseek (tempFile, 0, SEEK_END);
+    psteg_n = ftell (tempFile);
+    if ( psteg_n == 0 ) {
+       fprintf (stderr, "Empty file.\n");
+       exitPGP (1);
+    }
+ 
+    if ( user == NULL ) psteg_n += 16L;          /* permuta anche l'MD5... */
+ 
+    psteg_area = malloc ( psteg_n + LENSIZE );
+    if ( psteg_area == NULL ) {
+       fprintf (stderr, "Insufficient memory.\n");
+       exitPGP (1);
+    }
+ 
+    /* memorizzazione della lunghezza originaria del file */
+    for ( c = 0, i = user ? psteg_n : psteg_n -16L ; c < LENSIZE ; c++ ) {
+       psteg_area [c] = i & 0xff;
+       i >>= 8;
+    }
+ 
+    /* settaggio della session key: MD5(tempFile) e lettura del file */
+    psteg_set_key (tempFile, psteg_area + LENSIZE, user);
+ 
+    if ( user ) {
+       /* salvataggio della session key */
+       if ( !save_sess_key (user) ) {
+          fprintf (stderr, "Can't find a matching public key.\n");
+          exitPGP (1);
+       }
+    } else {
+       /* settaggio della session key: chiesta all'utente */
+       fprintf (stderr, "You need a pass phrase to encrypt the file.");
+       if (!GetHashedPassPhrase (psteg_key.kc, (unsigned char)1)) {
+          fprintf (stderr, "No pass phrase.\n");
+          exitPGP (1);
+       }
+       fprintf (stderr, "\n");
+       rsabits = 0;
+    }
+ 
+    psteg_n = ( psteg_n + LENSIZE ) << 3;
+    psteg_l = logaritmo_intero_sopra (psteg_n);
+    psteg_NN = ((unsigned long)1) << psteg_l;
+ 
+    if ( available < 0xffffffff ) {
+       psteg_NN += (unsigned long) rsabits;
+       if ( psteg_NN > available ) {
+          fprintf (stderr, "Can't load the file!\n");
+          fprintf (stderr, "(required: %lu, available: %lu)\n",
+                    psteg_NN, available);
+          exitPSTEG (1);
+       }
+       psteg_l = logaritmo_intero_sotto (available - (unsigned long) rsabits);
+       psteg_NN = ((unsigned long)1) << psteg_l;
+    }
+ }
+ 
+ void psteg_decrypt (FILE *outfile, char *user)
+ /*
+    se user == NULL, utilizza la crittazione a chiave singola
+  */
+ {
+    unsigned long i;
+    int pos, c;
+ 
+    fclose (tempFile);
+    tempFile = fopen (tempName, "rb");
+ 
+    /* recupero della session key */
+    if ( user ) {
+       if ( !load_sess_key (user) ) {
+          fprintf (stderr, "Can't find a valid secret key.\n");
+          exitPGP (1);
+       }
+    } else {
+       fprintf (stderr, "You need a pass phrase to decrypt the file.");
+       if (!GetHashedPassPhrase (psteg_key.kc, (unsigned char)1)) {
+          fprintf (stderr, "No pass phrase.\n");
+          exitPGP (1);
+       }
+       fprintf (stderr, "\n");
+       fseek (tempFile, 0, SEEK_END);
+       psteg_n = ftell (tempFile);
+       psteg_NN = psteg_n << 3;
+       psteg_l = logaritmo_intero_sotto (psteg_NN);
+       psteg_NN = ((unsigned long)1) << psteg_l;
+       psteg_n = psteg_NN >> 3;
+    }
+ 
+    if ( psteg_n <= LENSIZE ) {
+       fprintf (stderr, "Invalid file.\n");
+       exitPGP (1);
+    }
+ 
+    psteg_area = malloc ( psteg_n );
+    if ( psteg_area == NULL ) {
+       fprintf (stderr, "Insufficient memory.\n");
+       exitPGP (1);
+    }
+ 
+    /* azzeramento di tutto lo spazio */
+    for ( i = 0 ; i < psteg_n ; i++ ) psteg_area [i] = 0;
+ 
+    fseek (tempFile, 0, SEEK_SET);
+ 
+    for ( psteg_cnt = 0, pos = 8 ; psteg_cnt < psteg_NN ; psteg_cnt++ ) {
+       if ( pos == 8) {
+          c = getc (tempFile);
+          pos = 0;
+       }
+       pos++;
+       if ( c & 0x80 ) {
+          i = rnd_perm ();
+          psteg_area [ i >> 3 ] |= ( 1 << ( i & 7 ) );
+       }
+       c <<= 1;
+    }
+ 
+    /* recupero della lunghezza originaria del file */
+    for ( c = 0, i = 0 ; c < LENSIZE ; c++ ) {
+       i <<= 8;
+       i |= psteg_area [ LENSIZE - 1 - c];
+    }
+ 
+    fclose (tempFile);
+    tempFile = fopen (tempName, "wb");
+ 
+    if ( psteg_final_check (psteg_area + LENSIZE, i, user)) {
+       fprintf (stderr, "Inexistent data, invalid key, or corrupted data.\n");
+       exitPGP (1);
+    }
+ 
+    fclose (tempFile);
+    tempFile = fopen (tempName, "rb");
+    /* decompressione del file */
+    unzip (tempFile, outfile);
+ }
+ 
+ unsigned long psteg_inject (unsigned long inval)
+ {
+    unsigned long i;
+ 
+    if ( psteg_cnt < psteg_NN ) {
+       i = rnd_perm ();
+       psteg_cnt++;
+       if ( i <= psteg_n ) {
+          inval &= 0xfffffffe;
+          inval |= ( psteg_area [ i >> 3 ] >> ( i & 0x7 ) ) & 0x1;
+       }
+    } else if ( rsacnt < rsabits ) {
+       inval &= 0xfffffffe;
+       inval |= ( rsabuf [ rsacnt >> 3 ] >> ( 7 - ( rsacnt & 0x7 ) ) ) & 0x1;
+       rsacnt++;
+    }
+    return inval;
+ }
+ 
+ void psteg_exject (unsigned long outval)
+ {
+    static int c = 0;
+    static int i = 0;
+ 
+    c = ( c << 1 ) | ( outval & 0x1 );
+    if ( ++i == 8 ) {
+       putc (c, tempFile);
+       c = i = 0;
+    }
+ }
+ 
diff -PC2 ../pstorig/psteg.h ./psteg.h
*** ../pstorig/psteg.h	Thu Jan  1 01:00:00 1970
--- ./psteg.h	Fri Mar 28 12:24:04 1997
***************
*** 0 ****
--- 1,18 ----
+ #ifndef PSTEG_H
+ #define PSTEG_H
+ 
+ #include <stdio.h>
+ 
+ char *libpsteg_version ();
+ void breakHandler (int sig);
+ int to_lower (int c);
+ void exitPGP (int retval);
+ #define exitPSTEG(retval) exitPGP(retval)
+ void initPSTEG ();
+ void uuencode (char *src, FILE *fdst);
+ void psteg_crypt_init (FILE *infile, char *user, unsigned long available);
+ void psteg_decrypt (FILE *outfile, char *user);
+ unsigned long psteg_inject (unsigned long inval);
+ void psteg_exject (unsigned long outval);
+ 
+ #endif /* !PSTEG_H */
diff -PC2 ../pstorig/system.c ./system.c
*** ../pstorig/system.c	Sat Jan  6 21:02:56 1996
--- ./system.c	Mon Apr  7 13:25:40 1997
***************
*** 2003,2004 ****
--- 2003,2014 ----
  }
  #endif /* EBCDIC */
+ 
+ 
+ #ifdef BIOSKEY
+ #include <bios.h>
+ 
+ int getch ()
+ {
+    return bioskey (0);
+ }
+ #endif /* BIOSKEY */
diff -PC2 ../pstorig/wavpsteg.c ./wavpsteg.c
*** ../pstorig/wavpsteg.c	Thu Jan  1 01:00:00 1970
--- ./wavpsteg.c	Fri Mar 28 13:46:20 1997
***************
*** 0 ****
--- 1,139 ----
+ /*
+  * wavpsteg.c
+  *
+  * Steganografia a chiave pubblica.
+  * Utilizzo di file .wav come contenitori.
+  */
+ 
+ #include <stdio.h>
+ #include <stdlib.h>
+ #include <string.h>
+ #include "psteg.h"
+ 
+ static FILE *infile  = NULL;
+ static FILE *outfile = NULL;
+ 
+ static void exitWAVPSTEG (int retval)
+ {
+    if (infile)  fclose (infile);
+    if (outfile) fclose (outfile);
+    exitPSTEG (retval);
+ }
+ 
+ static void wav_crypt (char *user)
+ {
+    unsigned long i, l;
+    int c;
+ 
+    fread (&l, 1, 4, infile);
+    if( l != 0x46464952 ) {
+       fprintf (stderr, "Not a RIFF format file\n");
+       exitWAVPSTEG (1);
+    }
+    fread (&l, 1, 4, infile);
+    fread (&l, 1, 4, infile);
+    if( l != 0x45564157 ) {
+       fprintf (stderr, "Not a WAVE format chunk\n");
+       exitWAVPSTEG (1);
+    }
+    fread (&l, 1, 4, infile);
+    if( l != 0x20746D66 ) {
+       fprintf (stderr, "Not a fmt WAVE Format Chunk\n");
+       exitWAVPSTEG (1);
+    }
+    fread (&i, 1, 4, infile);
+    i += ftell (infile);
+    fseek (infile, i, SEEK_SET);
+    fread (&l, 1, 4, infile);
+    if( l != 0x61746164 ) {
+       fprintf (stderr, "Not a DATA chunk\n");
+       exitWAVPSTEG (1);
+    }
+    fread (&l, 1, 4, infile);
+    fseek (infile, 0, SEEK_END);
+    if ( l + i + 8 > ftell (infile) ) {
+       fprintf (stderr, "Input file is corrupted\n");
+       exitWAVPSTEG (1);
+    }
+ 
+    psteg_crypt_init (stdin, user, l);
+ 
+    fseek (infile, 0, SEEK_SET);
+    i += 8;
+    while ( i-- ) putc (getc (infile), outfile);
+    while ( l-- ) putc ( (int) psteg_inject ( getc (infile) ), outfile);
+    while ( ( c = getc (infile) ) != EOF ) putc (c, outfile);
+ }
+ 
+ static void wav_decrypt (char *user)
+ {
+    unsigned long l;
+ 
+    fread (&l, 1, 4, infile);
+    if( l != 0x46464952 ) {
+       fprintf (stderr, "Not a RIFF format file\n");
+       exitWAVPSTEG (1);
+    }
+    fread (&l, 1, 4, infile);
+    fread (&l, 1, 4, infile);
+    if( l != 0x45564157 ) {
+       fprintf (stderr, "Not a WAVE format chunk\n");
+       exitWAVPSTEG (1);
+    }
+    fread (&l, 1, 4, infile);
+    if( l != 0x20746D66 ) {
+       fprintf (stderr, "Not a fmt WAVE Format Chunk\n");
+       exitWAVPSTEG (1);
+    }
+    fread (&l, 1, 4, infile);
+    fseek (infile, l, SEEK_CUR);
+    fread (&l, 1, 4, infile);
+    if( l != 0x61746164 )
+    {
+       fprintf (stderr, "Not a DATA chunk\n");
+       exitWAVPSTEG (1);
+    }
+    fread (&l, 1, 4, infile);
+ 
+    while ( l-- ) psteg_exject ( getc (infile) );
+    psteg_decrypt (stdout, user);
+ }
+ 
+ static void usage ()
+ {
+    fprintf (stderr, "wavpsteg (%s)\n", libpsteg_version ());
+    fprintf (stderr, "usage:\n");
+    fprintf (stderr, "  wavpsteg e [ <pgp-id> ] <wav-in> <wav-out>\n");
+    fprintf (stderr, "  wavpsteg d [ <pgp-id> ] <wav-in>\n");
+    exitWAVPSTEG (1);
+ }
+ 
+ void main (int argc, char **argv)
+ {
+    int op = 0;
+ 
+    if ( argc < 2 ) usage ();
+ 
+    if ( !strcmp (argv [1], "e") ) op = 1;
+    if ( !strcmp (argv [1], "E") ) op = 1;
+    if ( !strcmp (argv [1], "d") ) op = 2;
+    if ( !strcmp (argv [1], "D") ) op = 2;
+    if ( !op ) usage ();
+    if (( op == 1 ) && ( argc != 5 ) && ( argc != 4 )) usage ();
+    if (( op == 2 ) && ( argc != 4 ) && ( argc != 3 )) usage ();
+ 
+    infile = fopen (argv [ argc + op - 3 ], "rb");
+    if ( infile == NULL )  usage ();
+    if ( op == 1 ) {
+       outfile = fopen (argv [ argc - 1 ], "wb");
+       if ( outfile == NULL ) usage ();
+    }
+ 
+    initPSTEG ();
+ 
+    if ( op == 1 ) wav_crypt   (( argc == 5 ) ? argv [2] : NULL);
+    else           wav_decrypt (( argc == 4 ) ? argv [2] : NULL);
+ 
+    exitWAVPSTEG (0);
+ }
+ 
